/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.common.FlowHelpers;
import com.amazonaws.services.simpleworkflow.flow.generic.GenericWorkflowClientExternal;
import com.amazonaws.services.simpleworkflow.flow.generic.SignalExternalWorkflowParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.StartWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.flow.generic.TerminateWorkflowExecutionParameters;
import com.amazonaws.services.simpleworkflow.model.DescribeWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.RequestCancelWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.Run;
import com.amazonaws.services.simpleworkflow.model.SignalWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.StartWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.TaskList;
import com.amazonaws.services.simpleworkflow.model.TerminateWorkflowExecutionRequest;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecutionDetail;
import java.util.UUID;

public class GenericWorkflowClientExternalImpl
implements GenericWorkflowClientExternal {
    private final String domain;
    private final AmazonSimpleWorkflow service;

    public GenericWorkflowClientExternalImpl(AmazonSimpleWorkflow service, String domain) {
        this.service = service;
        this.domain = domain;
    }

    @Override
    public WorkflowExecution startWorkflow(StartWorkflowExecutionParameters startParameters) {
        StartWorkflowExecutionRequest request = new StartWorkflowExecutionRequest();
        request.setDomain(this.domain);
        request.setInput(startParameters.getInput());
        request.setExecutionStartToCloseTimeout(FlowHelpers.secondsToDuration(startParameters.getExecutionStartToCloseTimeout()));
        request.setTaskStartToCloseTimeout(FlowHelpers.secondsToDuration(startParameters.getTaskStartToCloseTimeoutSeconds()));
        request.setTagList(startParameters.getTagList());
        String taskList = startParameters.getTaskList();
        if (taskList != null && !taskList.isEmpty()) {
            request.setTaskList(new TaskList().withName(taskList));
        }
        request.setWorkflowId(startParameters.getWorkflowId());
        request.setWorkflowType(startParameters.getWorkflowType());
        request.setTaskPriority(FlowHelpers.taskPriorityToString(startParameters.getTaskPriority()));
        Run result = this.service.startWorkflowExecution(request);
        WorkflowExecution execution = new WorkflowExecution().withRunId(result.getRunId()).withWorkflowId(request.getWorkflowId());
        return execution;
    }

    @Override
    public void signalWorkflowExecution(SignalExternalWorkflowParameters signalParameters) {
        SignalWorkflowExecutionRequest request = new SignalWorkflowExecutionRequest();
        request.setDomain(this.domain);
        request.setInput(signalParameters.getInput());
        request.setSignalName(signalParameters.getSignalName());
        request.setRunId(signalParameters.getRunId());
        request.setWorkflowId(signalParameters.getWorkflowId());
        this.service.signalWorkflowExecution(request);
    }

    @Override
    public void requestCancelWorkflowExecution(WorkflowExecution execution) {
        RequestCancelWorkflowExecutionRequest request = new RequestCancelWorkflowExecutionRequest();
        request.setDomain(this.domain);
        request.setRunId(execution.getRunId());
        request.setWorkflowId(execution.getWorkflowId());
        this.service.requestCancelWorkflowExecution(request);
    }

    @Override
    public String generateUniqueId() {
        String workflowId = UUID.randomUUID().toString();
        return workflowId;
    }

    @Override
    public String getWorkflowState(WorkflowExecution execution) {
        DescribeWorkflowExecutionRequest request = new DescribeWorkflowExecutionRequest();
        request.setDomain(this.domain);
        request.setExecution(execution);
        WorkflowExecutionDetail details = this.service.describeWorkflowExecution(request);
        return details.getLatestExecutionContext();
    }

    @Override
    public void terminateWorkflowExecution(TerminateWorkflowExecutionParameters terminateParameters) {
        TerminateWorkflowExecutionRequest request = new TerminateWorkflowExecutionRequest();
        WorkflowExecution workflowExecution = terminateParameters.getWorkflowExecution();
        request.setWorkflowId(workflowExecution.getWorkflowId());
        request.setRunId(workflowExecution.getRunId());
        request.setDomain(this.domain);
        request.setDetails(terminateParameters.getDetails());
        request.setReason(terminateParameters.getReason());
        request.setChildPolicy(terminateParameters.getChildPolicy());
        this.service.terminateWorkflowExecution(request);
    }
}

