/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MapConstraint;
import com.google.common.collect.MapConstraints;
import com.google.common.primitives.Primitives;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@GwtIncompatible
public final class MutableClassToInstanceMap<B>
extends MapConstraints.ConstrainedMap<Class<? extends B>, B>
implements ClassToInstanceMap<B>,
Serializable {
    private static final MapConstraint<Class<?>, Object> VALUE_CAN_BE_CAST_TO_KEY = new MapConstraint<Class<?>, Object>(){

        @Override
        public void checkKeyValue(Class<?> clazz, Object object) {
            MutableClassToInstanceMap.cast(clazz, object);
        }
    };

    public static <B> MutableClassToInstanceMap<B> create() {
        return new MutableClassToInstanceMap(new HashMap());
    }

    public static <B> MutableClassToInstanceMap<B> create(Map<Class<? extends B>, B> map) {
        return new MutableClassToInstanceMap<B>(map);
    }

    private MutableClassToInstanceMap(Map<Class<? extends B>, B> map) {
        super(map, VALUE_CAN_BE_CAST_TO_KEY);
    }

    @Override
    @CanIgnoreReturnValue
    public <T extends B> T putInstance(Class<T> clazz, T t) {
        return MutableClassToInstanceMap.cast(clazz, this.put(clazz, t));
    }

    @Override
    public <T extends B> T getInstance(Class<T> clazz) {
        return MutableClassToInstanceMap.cast(clazz, this.get(clazz));
    }

    @CanIgnoreReturnValue
    private static <B, T extends B> T cast(Class<T> clazz, B b) {
        return Primitives.wrap(clazz).cast(b);
    }

    private Object writeReplace() {
        return new SerializedForm(this.delegate());
    }

    private static final class SerializedForm<B>
    implements Serializable {
        private final Map<Class<? extends B>, B> backingMap;
        private static final long serialVersionUID = 0L;

        SerializedForm(Map<Class<? extends B>, B> map) {
            this.backingMap = map;
        }

        Object readResolve() {
            return MutableClassToInstanceMap.create(this.backingMap);
        }
    }
}

