/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.DenseImmutableTable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Ordering;
import com.google.common.collect.SparseImmutableTable;
import com.google.common.collect.Table;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;

@GwtCompatible
abstract class RegularImmutableTable<R, C, V>
extends ImmutableTable<R, C, V> {
    RegularImmutableTable() {
    }

    abstract Table.Cell<R, C, V> getCell(int var1);

    @Override
    final ImmutableSet<Table.Cell<R, C, V>> createCellSet() {
        return this.isEmpty() ? ImmutableSet.of() : new CellSet();
    }

    abstract V getValue(int var1);

    @Override
    final ImmutableCollection<V> createValues() {
        return this.isEmpty() ? ImmutableList.of() : new Values();
    }

    static <R, C, V> RegularImmutableTable<R, C, V> forCells(List<Table.Cell<R, C, V>> list, final @Nullable Comparator<? super R> comparator, final @Nullable Comparator<? super C> comparator2) {
        Preconditions.checkNotNull(list);
        if (comparator != null || comparator2 != null) {
            Comparator comparator3 = new Comparator<Table.Cell<R, C, V>>(){

                @Override
                public int compare(Table.Cell<R, C, V> cell, Table.Cell<R, C, V> cell2) {
                    int n;
                    int n2 = n = comparator == null ? 0 : comparator.compare(cell.getRowKey(), cell2.getRowKey());
                    if (n != 0) {
                        return n;
                    }
                    return comparator2 == null ? 0 : comparator2.compare(cell.getColumnKey(), cell2.getColumnKey());
                }
            };
            Collections.sort(list, comparator3);
        }
        return RegularImmutableTable.forCellsInternal(list, comparator, comparator2);
    }

    static <R, C, V> RegularImmutableTable<R, C, V> forCells(Iterable<Table.Cell<R, C, V>> iterable) {
        return RegularImmutableTable.forCellsInternal(iterable, null, null);
    }

    private static final <R, C, V> RegularImmutableTable<R, C, V> forCellsInternal(Iterable<Table.Cell<R, C, V>> iterable, @Nullable Comparator<? super R> comparator, @Nullable Comparator<? super C> comparator2) {
        LinkedHashSet<R> linkedHashSet = new LinkedHashSet<R>();
        LinkedHashSet<C> linkedHashSet2 = new LinkedHashSet<C>();
        ImmutableList<Table.Cell<R, C, V>> immutableList = ImmutableList.copyOf(iterable);
        for (Table.Cell<R, C, V> object2 : iterable) {
            linkedHashSet.add(object2.getRowKey());
            linkedHashSet2.add(object2.getColumnKey());
        }
        ImmutableSet immutableSet = comparator == null ? ImmutableSet.copyOf(linkedHashSet) : ImmutableSet.copyOf(Ordering.from(comparator).immutableSortedCopy(linkedHashSet));
        ImmutableSet immutableSet2 = comparator2 == null ? ImmutableSet.copyOf(linkedHashSet2) : ImmutableSet.copyOf(Ordering.from(comparator2).immutableSortedCopy(linkedHashSet2));
        return RegularImmutableTable.forOrderedComponents(immutableList, immutableSet, immutableSet2);
    }

    static <R, C, V> RegularImmutableTable<R, C, V> forOrderedComponents(ImmutableList<Table.Cell<R, C, V>> immutableList, ImmutableSet<R> immutableSet, ImmutableSet<C> immutableSet2) {
        return (long)immutableList.size() > (long)immutableSet.size() * (long)immutableSet2.size() / 2L ? new DenseImmutableTable<R, C, V>(immutableList, immutableSet, immutableSet2) : new SparseImmutableTable<R, C, V>(immutableList, immutableSet, immutableSet2);
    }

    private final class Values
    extends ImmutableList<V> {
        private Values() {
        }

        @Override
        public int size() {
            return RegularImmutableTable.this.size();
        }

        @Override
        public V get(int n) {
            return RegularImmutableTable.this.getValue(n);
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }

    private final class CellSet
    extends ImmutableSet.Indexed<Table.Cell<R, C, V>> {
        private CellSet() {
        }

        @Override
        public int size() {
            return RegularImmutableTable.this.size();
        }

        @Override
        Table.Cell<R, C, V> get(int n) {
            return RegularImmutableTable.this.getCell(n);
        }

        @Override
        public boolean contains(@Nullable Object object) {
            if (object instanceof Table.Cell) {
                Table.Cell cell = (Table.Cell)object;
                Object object2 = RegularImmutableTable.this.get(cell.getRowKey(), cell.getColumnKey());
                return object2 != null && object2.equals(cell.getValue());
            }
            return false;
        }

        @Override
        boolean isPartialView() {
            return false;
        }
    }
}

