/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.graph.ConfigurableNetwork;
import com.google.common.graph.DirectedMultiNetworkConnections;
import com.google.common.graph.DirectedNetworkConnections;
import com.google.common.graph.Graph;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.NetworkConnections;
import com.google.common.graph.UndirectedMultiNetworkConnections;
import com.google.common.graph.UndirectedNetworkConnections;
import java.util.Map;

@Beta
public final class ImmutableNetwork<N, E>
extends ConfigurableNetwork<N, E> {
    private ImmutableNetwork(Network<N, E> network) {
        super(NetworkBuilder.from(network), ImmutableNetwork.getNodeConnections(network), ImmutableNetwork.getEdgeToReferenceNode(network));
    }

    public static <N, E> ImmutableNetwork<N, E> copyOf(Network<N, E> network) {
        return network instanceof ImmutableNetwork ? (ImmutableNetwork<N, E>)network : new ImmutableNetwork<N, E>(network);
    }

    @Deprecated
    public static <N, E> ImmutableNetwork<N, E> copyOf(ImmutableNetwork<N, E> immutableNetwork) {
        return Preconditions.checkNotNull(immutableNetwork);
    }

    @Override
    public ImmutableGraph<N> asGraph() {
        final Graph graph = super.asGraph();
        return new ImmutableGraph<N>(){

            @Override
            protected Graph<N> delegate() {
                return graph;
            }
        };
    }

    private static <N, E> Map<N, NetworkConnections<N, E>> getNodeConnections(Network<N, E> network) {
        ImmutableMap.Builder<N, NetworkConnections<N, E>> builder = ImmutableMap.builder();
        for (N n : network.nodes()) {
            builder.put(n, ImmutableNetwork.connectionsOf(network, n));
        }
        return builder.build();
    }

    private static <N, E> Map<E, N> getEdgeToReferenceNode(Network<N, E> network) {
        ImmutableMap.Builder<E, N> builder = ImmutableMap.builder();
        for (E e : network.edges()) {
            builder.put(e, network.incidentNodes(e).nodeU());
        }
        return builder.build();
    }

    private static <N, E> NetworkConnections<N, E> connectionsOf(Network<N, E> network, N n) {
        if (network.isDirected()) {
            Map<E, N> map = Maps.asMap(network.inEdges(n), ImmutableNetwork.sourceNodeFn(network));
            Map<E, N> map2 = Maps.asMap(network.outEdges(n), ImmutableNetwork.targetNodeFn(network));
            int n2 = network.edgesConnecting(n, n).size();
            return network.allowsParallelEdges() ? DirectedMultiNetworkConnections.ofImmutable(map, map2, n2) : DirectedNetworkConnections.ofImmutable(map, map2, n2);
        }
        Map<E, N> map = Maps.asMap(network.incidentEdges(n), ImmutableNetwork.adjacentNodeFn(network, n));
        return network.allowsParallelEdges() ? UndirectedMultiNetworkConnections.ofImmutable(map) : UndirectedNetworkConnections.ofImmutable(map);
    }

    private static <N, E> Function<E, N> sourceNodeFn(final Network<N, E> network) {
        return new Function<E, N>(){

            @Override
            public N apply(E e) {
                return network.incidentNodes(e).source();
            }
        };
    }

    private static <N, E> Function<E, N> targetNodeFn(final Network<N, E> network) {
        return new Function<E, N>(){

            @Override
            public N apply(E e) {
                return network.incidentNodes(e).target();
            }
        };
    }

    private static <N, E> Function<E, N> adjacentNodeFn(final Network<N, E> network, final N n) {
        return new Function<E, N>(){

            @Override
            public N apply(E e) {
                return network.incidentNodes(e).adjacentNode(n);
            }
        };
    }
}

