/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;

@GwtCompatible(emulated=true)
abstract class InterruptibleTask
implements Runnable {
    private volatile Thread runner;
    private volatile boolean doneInterrupting;
    private static final AtomicHelper ATOMIC_HELPER;
    private static final Logger log;

    InterruptibleTask() {
    }

    @Override
    public final void run() {
        if (!ATOMIC_HELPER.compareAndSetRunner(this, null, Thread.currentThread())) {
            return;
        }
        try {
            this.runInterruptibly();
        }
        finally {
            if (this.wasInterrupted()) {
                while (!this.doneInterrupting) {
                    Thread.yield();
                }
            }
        }
    }

    abstract void runInterruptibly();

    abstract boolean wasInterrupted();

    final void interruptTask() {
        Thread thread = this.runner;
        if (thread != null) {
            thread.interrupt();
        }
        this.doneInterrupting = true;
    }

    static {
        AtomicHelper atomicHelper;
        log = Logger.getLogger(InterruptibleTask.class.getName());
        try {
            atomicHelper = new SafeAtomicHelper(AtomicReferenceFieldUpdater.newUpdater(InterruptibleTask.class, Thread.class, "runner"));
        }
        catch (Throwable throwable) {
            log.log(Level.SEVERE, "SafeAtomicHelper is broken!", throwable);
            atomicHelper = new SynchronizedAtomicHelper();
        }
        ATOMIC_HELPER = atomicHelper;
    }

    private static final class SynchronizedAtomicHelper
    extends AtomicHelper {
        private SynchronizedAtomicHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        boolean compareAndSetRunner(InterruptibleTask interruptibleTask, Thread thread, Thread thread2) {
            InterruptibleTask interruptibleTask2 = interruptibleTask;
            synchronized (interruptibleTask2) {
                if (interruptibleTask.runner == thread) {
                    interruptibleTask.runner = thread2;
                }
            }
            return true;
        }
    }

    private static final class SafeAtomicHelper
    extends AtomicHelper {
        final AtomicReferenceFieldUpdater<InterruptibleTask, Thread> runnerUpdater;

        SafeAtomicHelper(AtomicReferenceFieldUpdater atomicReferenceFieldUpdater) {
            this.runnerUpdater = atomicReferenceFieldUpdater;
        }

        @Override
        boolean compareAndSetRunner(InterruptibleTask interruptibleTask, Thread thread, Thread thread2) {
            return this.runnerUpdater.compareAndSet(interruptibleTask, thread, thread2);
        }
    }

    private static abstract class AtomicHelper {
        private AtomicHelper() {
        }

        abstract boolean compareAndSetRunner(InterruptibleTask var1, Thread var2, Thread var3);
    }
}

