/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.servicemetadata;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.regions.PartitionEndpointKey;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.ServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.DefaultServicePartitionMetadata;
import software.amazon.awssdk.regions.internal.util.ServiceMetadataUtils;
import software.amazon.awssdk.utils.ImmutableMap;
import software.amazon.awssdk.utils.Pair;

@SdkPublicApi
public final class NeptuneServiceMetadata
implements ServiceMetadata {
    private static final String ENDPOINT_PREFIX = "neptune";
    private static final List<Region> REGIONS = Collections.unmodifiableList(Arrays.asList(Region.of("af-south-1"), Region.of("ap-east-1"), Region.of("ap-northeast-1"), Region.of("ap-northeast-2"), Region.of("ap-south-1"), Region.of("ap-south-2"), Region.of("ap-southeast-1"), Region.of("ap-southeast-2"), Region.of("ap-southeast-4"), Region.of("ap-southeast-5"), Region.of("ap-southeast-6"), Region.of("ca-central-1"), Region.of("ca-west-1"), Region.of("eu-central-1"), Region.of("eu-central-2"), Region.of("eu-north-1"), Region.of("eu-south-2"), Region.of("eu-west-1"), Region.of("eu-west-2"), Region.of("eu-west-3"), Region.of("me-central-1"), Region.of("me-south-1"), Region.of("sa-east-1"), Region.of("us-east-1"), Region.of("us-east-2"), Region.of("us-west-1"), Region.of("us-west-2"), Region.of("cn-north-1"), Region.of("cn-northwest-1"), Region.of("us-gov-east-1"), Region.of("us-gov-west-1"), Region.of("us-iso-east-1"), Region.of("us-isof-east-1"), Region.of("us-isof-south-1")));
    private static final List<ServicePartitionMetadata> PARTITIONS = Collections.unmodifiableList(Arrays.asList(new DefaultServicePartitionMetadata("aws", null), new DefaultServicePartitionMetadata("aws-cn", null), new DefaultServicePartitionMetadata("aws-us-gov", null), new DefaultServicePartitionMetadata("aws-iso", null), new DefaultServicePartitionMetadata("aws-iso-f", null)));
    private static final Map<ServiceEndpointKey, String> SIGNING_REGIONS_BY_REGION = ImmutableMap.builder().put((Object)ServiceEndpointKey.builder().region(Region.of("af-south-1")).build(), (Object)"af-south-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-east-1")).build(), (Object)"ap-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), (Object)"ap-northeast-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), (Object)"ap-northeast-2").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-1")).build(), (Object)"ap-south-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-2")).build(), (Object)"ap-south-2").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), (Object)"ap-southeast-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), (Object)"ap-southeast-2").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).build(), (Object)"ap-southeast-4").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-5")).build(), (Object)"ap-southeast-5").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-6")).build(), (Object)"ap-southeast-6").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).build(), (Object)"ca-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).build(), (Object)"ca-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), (Object)"eu-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-2")).build(), (Object)"eu-central-2").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-north-1")).build(), (Object)"eu-north-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-south-2")).build(), (Object)"eu-south-2").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), (Object)"eu-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), (Object)"eu-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-3")).build(), (Object)"eu-west-3").put((Object)ServiceEndpointKey.builder().region(Region.of("me-central-1")).build(), (Object)"me-central-1").put((Object)ServiceEndpointKey.builder().region(Region.of("me-south-1")).build(), (Object)"me-south-1").put((Object)ServiceEndpointKey.builder().region(Region.of("sa-east-1")).build(), (Object)"sa-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), (Object)"us-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), (Object)"us-east-2").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-1")).build(), (Object)"us-west-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), (Object)"us-west-2").put((Object)ServiceEndpointKey.builder().region(Region.of("cn-north-1")).build(), (Object)"cn-north-1").put((Object)ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).build(), (Object)"cn-northwest-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).build(), (Object)"us-iso-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isof-east-1")).build(), (Object)"us-isof-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isof-south-1")).build(), (Object)"us-isof-south-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).build(), (Object)"us-gov-east-1").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).build(), (Object)"us-gov-west-1").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> SIGNING_REGIONS_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> DNS_SUFFIXES_BY_REGION = ImmutableMap.builder().build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> DNS_SUFFIXES_BY_PARTITION = ImmutableMap.builder().build();
    private static final Map<ServiceEndpointKey, String> HOSTNAMES_BY_REGION = ImmutableMap.builder().put((Object)ServiceEndpointKey.builder().region(Region.of("af-south-1")).build(), (Object)"rds.af-south-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-east-1")).build(), (Object)"rds.ap-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-1")).build(), (Object)"rds.ap-northeast-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-northeast-2")).build(), (Object)"rds.ap-northeast-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-1")).build(), (Object)"rds.ap-south-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-south-2")).build(), (Object)"rds.ap-south-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-1")).build(), (Object)"rds.ap-southeast-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-2")).build(), (Object)"rds.ap-southeast-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-4")).build(), (Object)"rds.ap-southeast-4.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-5")).build(), (Object)"rds.ap-southeast-5.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ap-southeast-6")).build(), (Object)"rds.ap-southeast-6.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-central-1")).build(), (Object)"rds.ca-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("ca-west-1")).build(), (Object)"rds.ca-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-1")).build(), (Object)"rds.eu-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-central-2")).build(), (Object)"rds.eu-central-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-north-1")).build(), (Object)"rds.eu-north-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-south-2")).build(), (Object)"rds.eu-south-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-1")).build(), (Object)"rds.eu-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-2")).build(), (Object)"rds.eu-west-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("eu-west-3")).build(), (Object)"rds.eu-west-3.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("me-central-1")).build(), (Object)"rds.me-central-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("me-south-1")).build(), (Object)"rds.me-south-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("sa-east-1")).build(), (Object)"rds.sa-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-1")).build(), (Object)"rds.us-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-east-2")).build(), (Object)"rds.us-east-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-1")).build(), (Object)"rds.us-west-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-west-2")).build(), (Object)"rds.us-west-2.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("cn-north-1")).build(), (Object)"rds.cn-north-1.amazonaws.com.cn").put((Object)ServiceEndpointKey.builder().region(Region.of("cn-northwest-1")).build(), (Object)"rds.cn-northwest-1.amazonaws.com.cn").put((Object)ServiceEndpointKey.builder().region(Region.of("us-iso-east-1")).build(), (Object)"rds.us-iso-east-1.c2s.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isof-east-1")).build(), (Object)"rds.us-isof-east-1.csp.hci.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-isof-south-1")).build(), (Object)"rds.us-isof-south-1.csp.hci.ic.gov").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-east-1")).build(), (Object)"rds.us-gov-east-1.amazonaws.com").put((Object)ServiceEndpointKey.builder().region(Region.of("us-gov-west-1")).build(), (Object)"rds.us-gov-west-1.amazonaws.com").build();
    private static final Map<Pair<String, PartitionEndpointKey>, String> HOSTNAMES_BY_PARTITION = ImmutableMap.builder().build();

    @Override
    public List<Region> regions() {
        return REGIONS;
    }

    @Override
    public List<ServicePartitionMetadata> servicePartitions() {
        return PARTITIONS;
    }

    @Override
    public URI endpointFor(ServiceEndpointKey key) {
        return ServiceMetadataUtils.endpointFor(ServiceMetadataUtils.hostname(key, HOSTNAMES_BY_REGION, HOSTNAMES_BY_PARTITION), ENDPOINT_PREFIX, key.region().id(), ServiceMetadataUtils.dnsSuffix(key, DNS_SUFFIXES_BY_REGION, DNS_SUFFIXES_BY_PARTITION));
    }

    @Override
    public Region signingRegion(ServiceEndpointKey key) {
        return ServiceMetadataUtils.signingRegion(key, SIGNING_REGIONS_BY_REGION, SIGNING_REGIONS_BY_PARTITION);
    }
}

