/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.HttpConstraintElement;
import javax.servlet.HttpMethodConstraintElement;
import javax.servlet.annotation.HttpMethodConstraint;
import javax.servlet.annotation.ServletSecurity;

public class ServletSecurityElement
extends HttpConstraintElement {
    private final Map<String, HttpMethodConstraintElement> methodConstraints = new HashMap<String, HttpMethodConstraintElement>();

    public ServletSecurityElement() {
    }

    public ServletSecurityElement(HttpConstraintElement httpConstraintElement) {
        this(httpConstraintElement, null);
    }

    public ServletSecurityElement(Collection<HttpMethodConstraintElement> collection) {
        this.addHttpMethodConstraints(collection);
    }

    public ServletSecurityElement(HttpConstraintElement httpConstraintElement, Collection<HttpMethodConstraintElement> collection) {
        super(httpConstraintElement.getEmptyRoleSemantic(), httpConstraintElement.getTransportGuarantee(), httpConstraintElement.getRolesAllowed());
        this.addHttpMethodConstraints(collection);
    }

    public ServletSecurityElement(ServletSecurity servletSecurity) {
        this(new HttpConstraintElement(servletSecurity.value().value(), servletSecurity.value().transportGuarantee(), servletSecurity.value().rolesAllowed()));
        ArrayList<HttpMethodConstraintElement> arrayList = new ArrayList<HttpMethodConstraintElement>();
        HttpMethodConstraint[] httpMethodConstraintArray = servletSecurity.httpMethodConstraints();
        if (httpMethodConstraintArray != null) {
            for (int i = 0; i < httpMethodConstraintArray.length; ++i) {
                HttpMethodConstraintElement httpMethodConstraintElement = new HttpMethodConstraintElement(httpMethodConstraintArray[i].value(), new HttpConstraintElement(httpMethodConstraintArray[i].emptyRoleSemantic(), httpMethodConstraintArray[i].transportGuarantee(), httpMethodConstraintArray[i].rolesAllowed()));
                arrayList.add(httpMethodConstraintElement);
            }
        }
        this.addHttpMethodConstraints(arrayList);
    }

    public Collection<HttpMethodConstraintElement> getHttpMethodConstraints() {
        HashSet<HttpMethodConstraintElement> hashSet = new HashSet<HttpMethodConstraintElement>();
        hashSet.addAll(this.methodConstraints.values());
        return hashSet;
    }

    public Collection<String> getMethodNames() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.methodConstraints.keySet());
        return hashSet;
    }

    private void addHttpMethodConstraints(Collection<HttpMethodConstraintElement> collection) {
        if (collection == null) {
            return;
        }
        for (HttpMethodConstraintElement httpMethodConstraintElement : collection) {
            String string = httpMethodConstraintElement.getMethodName();
            if (this.methodConstraints.containsKey(string)) {
                throw new IllegalArgumentException("Duplicate method name: " + string);
            }
            this.methodConstraints.put(string, httpMethodConstraintElement);
        }
    }
}

