/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

class NoBodyOutputStream
extends ServletOutputStream {
    private static final String LSTRING_FILE = "javax.servlet.http.LocalStrings";
    private static final ResourceBundle lStrings = ResourceBundle.getBundle("javax.servlet.http.LocalStrings");
    private int contentLength = 0;

    NoBodyOutputStream() {
    }

    int getContentLength() {
        return this.contentLength;
    }

    @Override
    public void write(int n) {
        ++this.contentLength;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException(lStrings.getString("err.io.nullArray"));
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            String string = lStrings.getString("err.io.indexOutOfBounds");
            Object[] objectArray = new Object[]{n, n2, byArray.length};
            string = MessageFormat.format(string, objectArray);
            throw new IndexOutOfBoundsException(string);
        }
        this.contentLength += n2;
    }

    @Override
    public boolean isReady() {
        return false;
    }

    @Override
    public void setWriteListener(WriteListener writeListener) {
    }
}

