/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.async;

import java.io.File;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.async.BlockingInputStreamAsyncRequestBody;
import software.amazon.awssdk.core.async.BlockingOutputStreamAsyncRequestBody;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.internal.async.ByteArrayAsyncRequestBody;
import software.amazon.awssdk.core.internal.async.FileAsyncRequestBody;
import software.amazon.awssdk.core.internal.async.InputStreamWithExecutorAsyncRequestBody;
import software.amazon.awssdk.utils.BinaryUtils;

@SdkPublicApi
public interface AsyncRequestBody
extends SdkPublisher<ByteBuffer> {
    public Optional<Long> contentLength();

    default public String contentType() {
        return "application/octet-stream";
    }

    public static AsyncRequestBody fromPublisher(final Publisher<ByteBuffer> publisher) {
        return new AsyncRequestBody(){

            @Override
            public Optional<Long> contentLength() {
                return Optional.empty();
            }

            public void subscribe(Subscriber<? super ByteBuffer> s) {
                publisher.subscribe(s);
            }
        };
    }

    public static AsyncRequestBody fromFile(Path path) {
        return (AsyncRequestBody)FileAsyncRequestBody.builder().path(path).build();
    }

    public static AsyncRequestBody fromFile(File file) {
        return (AsyncRequestBody)FileAsyncRequestBody.builder().path(file.toPath()).build();
    }

    public static AsyncRequestBody fromString(String string, Charset cs) {
        return new ByteArrayAsyncRequestBody(string.getBytes(cs), "text/plain; charset=" + cs.name());
    }

    public static AsyncRequestBody fromString(String string) {
        return AsyncRequestBody.fromString(string, StandardCharsets.UTF_8);
    }

    public static AsyncRequestBody fromBytes(byte[] bytes) {
        return new ByteArrayAsyncRequestBody(bytes, "application/octet-stream");
    }

    public static AsyncRequestBody fromByteBuffer(ByteBuffer byteBuffer) {
        return AsyncRequestBody.fromBytes(BinaryUtils.copyAllBytesFrom((ByteBuffer)byteBuffer));
    }

    public static AsyncRequestBody fromInputStream(InputStream inputStream, Long contentLength, ExecutorService executor) {
        return new InputStreamWithExecutorAsyncRequestBody(inputStream, contentLength, executor);
    }

    public static BlockingInputStreamAsyncRequestBody forBlockingInputStream(Long contentLength) {
        return new BlockingInputStreamAsyncRequestBody(contentLength);
    }

    public static BlockingOutputStreamAsyncRequestBody forBlockingOutputStream(Long contentLength) {
        return new BlockingOutputStreamAsyncRequestBody(contentLength);
    }

    public static AsyncRequestBody empty() {
        return AsyncRequestBody.fromBytes(new byte[0]);
    }
}

