/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.async;

import java.nio.ByteBuffer;
import java.util.Optional;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class ByteArrayAsyncRequestBody
implements AsyncRequestBody {
    private static final Logger log = Logger.loggerFor(ByteArrayAsyncRequestBody.class);
    private final byte[] bytes;
    private final String mimetype;

    public ByteArrayAsyncRequestBody(byte[] bytes, String mimetype) {
        this.bytes = (byte[])bytes.clone();
        this.mimetype = mimetype;
    }

    @Override
    public Optional<Long> contentLength() {
        return Optional.of(Long.valueOf(this.bytes.length));
    }

    @Override
    public String contentType() {
        return this.mimetype;
    }

    public void subscribe(final Subscriber<? super ByteBuffer> s) {
        if (s == null) {
            throw new NullPointerException("Subscription MUST NOT be null.");
        }
        try {
            s.onSubscribe(new Subscription(){
                private boolean done = false;

                public void request(long n) {
                    if (this.done) {
                        return;
                    }
                    if (n > 0L) {
                        this.done = true;
                        s.onNext((Object)ByteBuffer.wrap(ByteArrayAsyncRequestBody.this.bytes));
                        s.onComplete();
                    } else {
                        s.onError((Throwable)new IllegalArgumentException("\u00a73.9: non-positive requests are not allowed!"));
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void cancel() {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (!this.done) {
                            this.done = true;
                        }
                    }
                }
            });
        }
        catch (Throwable ex) {
            log.error(() -> s + " violated the Reactive Streams rule 2.13 by throwing an exception from onSubscribe.", ex);
        }
    }
}

