/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.xembly.XmlContentException;

@Immutable
final class Arg {
    private final transient String value;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    Arg(String val) throws XmlContentException {
        String string = val;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string);
        try {
            for (char chr : val.toCharArray()) {
                Arg.legal(chr);
            }
            this.value = val;
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    public String toString() {
        String escaped = Arg.escape(this.value);
        return new StringBuilder(this.value.length() + 2 + escaped.length()).append('\"').append(escaped).append('\"').toString();
    }

    public String raw() {
        return this.value;
    }

    public static String unescape(String text) throws XmlContentException {
        StringBuilder output = new StringBuilder(text.length());
        char[] chars = text.toCharArray();
        if (chars.length < 2) {
            throw new IllegalArgumentException("internal error, argument can't be shorter than 2 chars");
        }
        int len = chars.length - 1;
        for (int idx = 1; idx < len; ++idx) {
            if (chars[idx] == '&') {
                StringBuilder sbuf = new StringBuilder(10);
                while (chars[idx] != ';') {
                    if (++idx == chars.length) {
                        throw new XmlContentException("reached EOF while parsing XML symbol");
                    }
                    sbuf.append(chars[idx]);
                }
                output.append(Arg.symbol(sbuf.substring(0, sbuf.length() - 1)));
                continue;
            }
            output.append(chars[idx]);
        }
        return output.toString();
    }

    private static String escape(String text) {
        StringBuilder output = new StringBuilder(text.length());
        for (char chr : text.toCharArray()) {
            if (chr < ' ') {
                output.append("&#").append((int)chr).append(';');
                continue;
            }
            if (chr == '\"') {
                output.append("&quot;");
                continue;
            }
            if (chr == '&') {
                output.append("&amp;");
                continue;
            }
            if (chr == '\'') {
                output.append("&apos;");
                continue;
            }
            if (chr == '<') {
                output.append("&lt;");
                continue;
            }
            if (chr == '>') {
                output.append("&gt;");
                continue;
            }
            output.append(chr);
        }
        return output.toString();
    }

    private static char symbol(String symbol) throws XmlContentException {
        int chr;
        if ('#' == symbol.charAt(0)) {
            int num = Integer.parseInt(symbol.substring(1));
            chr = Arg.legal((char)num);
        } else if ("apos".equalsIgnoreCase(symbol)) {
            chr = 39;
        } else if ("quot".equalsIgnoreCase(symbol)) {
            chr = 34;
        } else if ("lt".equalsIgnoreCase(symbol)) {
            chr = 60;
        } else if ("gt".equalsIgnoreCase(symbol)) {
            chr = 62;
        } else if ("amp".equalsIgnoreCase(symbol)) {
            chr = 38;
        } else {
            throw new XmlContentException(String.format("unknown XML symbol &%s;", symbol));
        }
        return (char)chr;
    }

    private static char legal(char chr) throws XmlContentException {
        Arg.range(chr, 0, 8);
        Arg.range(chr, 11, 12);
        Arg.range(chr, 14, 31);
        Arg.range(chr, 127, 132);
        Arg.range(chr, 134, 159);
        return chr;
    }

    private static void range(char chr, int left, int right) throws XmlContentException {
        if (chr >= left && chr <= right) {
            throw new XmlContentException(String.format("Character #%02X is in restricted XML range #%02X-#%02X, see http://www.w3.org/TR/2004/REC-xml11-20040204/#charsets", chr, left, right));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Arg)) {
            return false;
        }
        Arg other = (Arg)o;
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $value = this.value;
        result = result * 31 + ($value == null ? 0 : $value.hashCode());
        return result;
    }

    static {
        Arg.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Arg.java", Arg.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "org.xembly.Arg", "java.lang.String", "val", "org.xembly.XmlContentException"), 58);
    }
}

