/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.aj.ImmutabilityChecker;
import com.jcabi.log.Logger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xembly.Arg;
import org.xembly.Directive;
import org.xembly.DomPointer;
import org.xembly.ImpossibleModificationException;
import org.xembly.XmlContentException;

@Immutable
final class XpathDirective
implements Directive {
    private static final XPathFactory FACTORY;
    private static final Pattern ROOT_ONLY;
    private final transient Arg expr;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    XpathDirective(String path) throws XmlContentException {
        String string = path;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        try {
            JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
            try {
            }
            finally {
                ImmutabilityChecker.aspectOf().after(joinPoint2);
            }
            this.expr = new Arg(path);
        }
        finally {
            ImmutabilityChecker.aspectOf().after(joinPoint);
        }
    }

    public String toString() {
        return String.format("XPATH %s", this.expr);
    }

    @Override
    public Directive.Pointer exec(Node dom, Directive.Pointer ptr, Directive.Stack stack) throws ImpossibleModificationException {
        String query = this.expr.raw();
        Matcher matcher = ROOT_ONLY.matcher(query);
        Collection<Node> targets = matcher.matches() ? XpathDirective.rootOnly(matcher.group(1), dom) : XpathDirective.traditional(query, dom, ptr);
        return new DomPointer(targets);
    }

    private static Collection<Node> rootOnly(String root, Node dom) {
        Element target = dom.getOwnerDocument() == null ? ((Document)Document.class.cast(dom)).getDocumentElement() : dom.getOwnerDocument().getDocumentElement();
        List<Node> targets = root != null && target != null && ("*".equals(root) || target.getNodeName().equals(root)) ? Collections.singletonList(target) : Collections.emptyList();
        return targets;
    }

    private static Collection<Node> traditional(String query, Node dom, Collection<Node> current) throws ImpossibleModificationException {
        XPath xpath = FACTORY.newXPath();
        HashSet<Node> targets = new HashSet<Node>(0);
        for (Node node : XpathDirective.roots(dom, current)) {
            NodeList list;
            try {
                list = (NodeList)NodeList.class.cast(xpath.evaluate(query, node, XPathConstants.NODESET));
            }
            catch (XPathExpressionException ex) {
                throw new ImpossibleModificationException(String.format("invalid XPath expr '%s'", query), ex);
            }
            int len = list.getLength();
            for (int idx = 0; idx < len; ++idx) {
                targets.add(list.item(idx));
            }
        }
        return targets;
    }

    private static Iterable<Node> roots(Node dom, Collection<Node> nodes) {
        Collection<Node> roots = nodes.isEmpty() ? (dom.getOwnerDocument() == null ? Collections.singletonList(dom) : Collections.singletonList(dom.getOwnerDocument().getDocumentElement())) : nodes;
        return roots;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XpathDirective)) {
            return false;
        }
        XpathDirective other = (XpathDirective)o;
        Arg this$expr = this.expr;
        Arg other$expr = other.expr;
        return !(this$expr == null ? other$expr != null : !((Object)this$expr).equals(other$expr));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Arg $expr = this.expr;
        result = result * 59 + ($expr == null ? 0 : ((Object)$expr).hashCode());
        return result;
    }

    static {
        XpathDirective.ajc$preClinit();
        FACTORY = XPathFactory.newInstance();
        ROOT_ONLY = Pattern.compile("/([^/\\(\\[\\{:]+)");
        Logger.debug(XpathDirective.class, (String)"XPathFactory: %s", (Object[])new Object[]{FACTORY.getClass().getName()});
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("XpathDirective.java", XpathDirective.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.xembly.Directive", "", "", ""), 88);
        ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "org.xembly.XpathDirective", "java.lang.String", "path", "org.xembly.XmlContentException"), 88);
    }
}

