// $ANTLR 3.5.2 org/xembly/Xembly.g 2019-12-07 09:57:15

    package org.xembly;
    import java.util.Collection;
    import java.util.LinkedList;


import org.antlr.runtime.*;
import java.util.Stack;
import java.util.List;
import java.util.ArrayList;

/**
 * Copyright (c) 2013-2019, xembly.org
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met: 1) Redistributions of source code must retain the above
 * copyright notice, this list of conditions and the following
 * disclaimer. 2) Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided
 * with the distribution. 3) Neither the name of the xembly.org nor
 * the names of its contributors may be used to endorse or promote
 * products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
@SuppressWarnings("all")
public class XemblyParser extends Parser {
	public static final String[] tokenNames = new String[] {
		"<invalid>", "<EOR>", "<DOWN>", "<UP>", "COLON", "COMMA", "DIGIT", "SEMICOLON", 
		"SPACE", "TEXT", "'ADD'", "'ADDIF'", "'ATTR'", "'CDATA'", "'COMMENT'", 
		"'PI'", "'POP'", "'PUSH'", "'REMOVE'", "'SET'", "'STRICT'", "'UP'", "'XPATH'", 
		"'XSET'"
	};
	public static final int EOF=-1;
	public static final int T__10=10;
	public static final int T__11=11;
	public static final int T__12=12;
	public static final int T__13=13;
	public static final int T__14=14;
	public static final int T__15=15;
	public static final int T__16=16;
	public static final int T__17=17;
	public static final int T__18=18;
	public static final int T__19=19;
	public static final int T__20=20;
	public static final int T__21=21;
	public static final int T__22=22;
	public static final int T__23=23;
	public static final int COLON=4;
	public static final int COMMA=5;
	public static final int DIGIT=6;
	public static final int SEMICOLON=7;
	public static final int SPACE=8;
	public static final int TEXT=9;

	// delegates
	public Parser[] getDelegates() {
		return new Parser[] {};
	}

	// delegators


	public XemblyParser(TokenStream input) {
		this(input, new RecognizerSharedState());
	}
	public XemblyParser(TokenStream input, RecognizerSharedState state) {
		super(input, state);
	}

	@Override public String[] getTokenNames() { return XemblyParser.tokenNames; }
	@Override public String getGrammarFileName() { return "org/xembly/Xembly.g"; }


	    @Override
	    public void emitErrorMessage(String msg) {
	        throw new ParsingException(msg);
	    }



	// $ANTLR start "directives"
	// org/xembly/Xembly.g:56:1: directives returns [Collection<Directive> ret] : ( ( label COLON )? directive SEMICOLON )* EOF ;
	public final Collection<Directive> directives() throws RecognitionException {
		Collection<Directive> ret = null;


		Directive directive1 =null;

		 ret = new LinkedList<Directive>(); 
		try {
			// org/xembly/Xembly.g:58:5: ( ( ( label COLON )? directive SEMICOLON )* EOF )
			// org/xembly/Xembly.g:59:5: ( ( label COLON )? directive SEMICOLON )* EOF
			{
			// org/xembly/Xembly.g:59:5: ( ( label COLON )? directive SEMICOLON )*
			loop2:
			while (true) {
				int alt2=2;
				int LA2_0 = input.LA(1);
				if ( (LA2_0==DIGIT||(LA2_0 >= 10 && LA2_0 <= 23)) ) {
					alt2=1;
				}

				switch (alt2) {
				case 1 :
					// org/xembly/Xembly.g:60:9: ( label COLON )? directive SEMICOLON
					{
					// org/xembly/Xembly.g:60:9: ( label COLON )?
					int alt1=2;
					int LA1_0 = input.LA(1);
					if ( (LA1_0==DIGIT) ) {
						alt1=1;
					}
					switch (alt1) {
						case 1 :
							// org/xembly/Xembly.g:60:10: label COLON
							{
							pushFollow(FOLLOW_label_in_directives77);
							label();
							state._fsp--;

							match(input,COLON,FOLLOW_COLON_in_directives79); 
							}
							break;

					}

					pushFollow(FOLLOW_directive_in_directives91);
					directive1=directive();
					state._fsp--;

					match(input,SEMICOLON,FOLLOW_SEMICOLON_in_directives101); 
					 ret.add(directive1); 
					}
					break;

				default :
					break loop2;
				}
			}

			match(input,EOF,FOLLOW_EOF_in_directives124); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "directives"



	// $ANTLR start "directive"
	// org/xembly/Xembly.g:68:1: directive returns [Directive ret] : ( 'XPATH' argument | 'SET' argument | 'XSET' argument | 'ATTR' name= argument COMMA value= argument | 'ADD' argument | 'ADDIF' argument | 'REMOVE' | 'STRICT' argument | 'UP' | 'PI' target= argument data= argument | 'PUSH' | 'POP' | 'CDATA' argument | 'COMMENT' argument );
	public final Directive directive() throws RecognitionException {
		Directive ret = null;


		Object name =null;
		Object value =null;
		Object target =null;
		Object data =null;
		Object argument2 =null;
		Object argument3 =null;
		Object argument4 =null;
		Object argument5 =null;
		Object argument6 =null;
		Object argument7 =null;
		Object argument8 =null;
		Object argument9 =null;

		try {
			// org/xembly/Xembly.g:69:5: ( 'XPATH' argument | 'SET' argument | 'XSET' argument | 'ATTR' name= argument COMMA value= argument | 'ADD' argument | 'ADDIF' argument | 'REMOVE' | 'STRICT' argument | 'UP' | 'PI' target= argument data= argument | 'PUSH' | 'POP' | 'CDATA' argument | 'COMMENT' argument )
			int alt3=14;
			switch ( input.LA(1) ) {
			case 22:
				{
				alt3=1;
				}
				break;
			case 19:
				{
				alt3=2;
				}
				break;
			case 23:
				{
				alt3=3;
				}
				break;
			case 12:
				{
				alt3=4;
				}
				break;
			case 10:
				{
				alt3=5;
				}
				break;
			case 11:
				{
				alt3=6;
				}
				break;
			case 18:
				{
				alt3=7;
				}
				break;
			case 20:
				{
				alt3=8;
				}
				break;
			case 21:
				{
				alt3=9;
				}
				break;
			case 15:
				{
				alt3=10;
				}
				break;
			case 17:
				{
				alt3=11;
				}
				break;
			case 16:
				{
				alt3=12;
				}
				break;
			case 13:
				{
				alt3=13;
				}
				break;
			case 14:
				{
				alt3=14;
				}
				break;
			default:
				NoViableAltException nvae =
					new NoViableAltException("", 3, 0, input);
				throw nvae;
			}
			switch (alt3) {
				case 1 :
					// org/xembly/Xembly.g:70:5: 'XPATH' argument
					{
					match(input,22,FOLLOW_22_in_directive149); 
					pushFollow(FOLLOW_argument_in_directive151);
					argument2=argument();
					state._fsp--;


					        try {
					            ret = new XpathDirective(argument2.toString());
					        } catch (final XmlContentException ex) {
					            throw new ParsingException(ex);
					        }
					    
					}
					break;
				case 2 :
					// org/xembly/Xembly.g:79:5: 'SET' argument
					{
					match(input,19,FOLLOW_19_in_directive169); 
					pushFollow(FOLLOW_argument_in_directive171);
					argument3=argument();
					state._fsp--;


					        try {
					            ret = new SetDirective(argument3.toString());
					        } catch (final XmlContentException ex) {
					            throw new ParsingException(ex);
					        }
					    
					}
					break;
				case 3 :
					// org/xembly/Xembly.g:88:5: 'XSET' argument
					{
					match(input,23,FOLLOW_23_in_directive189); 
					pushFollow(FOLLOW_argument_in_directive191);
					argument4=argument();
					state._fsp--;


					        try {
					            ret = new XsetDirective(argument4.toString());
					        } catch (final XmlContentException ex) {
					            throw new ParsingException(ex);
					        }
					    
					}
					break;
				case 4 :
					// org/xembly/Xembly.g:97:5: 'ATTR' name= argument COMMA value= argument
					{
					match(input,12,FOLLOW_12_in_directive209); 
					pushFollow(FOLLOW_argument_in_directive213);
					name=argument();
					state._fsp--;

					match(input,COMMA,FOLLOW_COMMA_in_directive215); 
					pushFollow(FOLLOW_argument_in_directive219);
					value=argument();
					state._fsp--;


					        try {
					            ret = new AttrDirective(name.toString(), value.toString());
					        } catch (final XmlContentException ex) {
					            throw new ParsingException(ex);
					        }
					    
					}
					break;
				case 5 :
					// org/xembly/Xembly.g:106:5: 'ADD' argument
					{
					match(input,10,FOLLOW_10_in_directive237); 
					pushFollow(FOLLOW_argument_in_directive239);
					argument5=argument();
					state._fsp--;


					        try {
					            ret = new AddDirective(argument5.toString());
					        } catch (final XmlContentException ex) {
					            throw new ParsingException(ex);
					        }
					    
					}
					break;
				case 6 :
					// org/xembly/Xembly.g:115:5: 'ADDIF' argument
					{
					match(input,11,FOLLOW_11_in_directive257); 
					pushFollow(FOLLOW_argument_in_directive259);
					argument6=argument();
					state._fsp--;


					        try {
					            ret = new AddIfDirective(argument6.toString());
					        } catch (final XmlContentException ex) {
					            throw new ParsingException(ex);
					        }
					    
					}
					break;
				case 7 :
					// org/xembly/Xembly.g:124:5: 'REMOVE'
					{
					match(input,18,FOLLOW_18_in_directive277); 

					        ret = new RemoveDirective();
					    
					}
					break;
				case 8 :
					// org/xembly/Xembly.g:129:5: 'STRICT' argument
					{
					match(input,20,FOLLOW_20_in_directive295); 
					pushFollow(FOLLOW_argument_in_directive297);
					argument7=argument();
					state._fsp--;


					        ret = new StrictDirective(Integer.parseInt(argument7.toString()));
					    
					}
					break;
				case 9 :
					// org/xembly/Xembly.g:134:5: 'UP'
					{
					match(input,21,FOLLOW_21_in_directive315); 

					        ret = new UpDirective();
					    
					}
					break;
				case 10 :
					// org/xembly/Xembly.g:139:5: 'PI' target= argument data= argument
					{
					match(input,15,FOLLOW_15_in_directive333); 
					pushFollow(FOLLOW_argument_in_directive337);
					target=argument();
					state._fsp--;

					pushFollow(FOLLOW_argument_in_directive341);
					data=argument();
					state._fsp--;


					        try {
					            ret = new PiDirective(target.toString(), data.toString());
					        } catch (final XmlContentException ex) {
					            throw new ParsingException(ex);
					        }
					    
					}
					break;
				case 11 :
					// org/xembly/Xembly.g:148:5: 'PUSH'
					{
					match(input,17,FOLLOW_17_in_directive359); 

					        ret = new PushDirective();
					    
					}
					break;
				case 12 :
					// org/xembly/Xembly.g:153:5: 'POP'
					{
					match(input,16,FOLLOW_16_in_directive377); 

					        ret = new PopDirective();
					    
					}
					break;
				case 13 :
					// org/xembly/Xembly.g:158:5: 'CDATA' argument
					{
					match(input,13,FOLLOW_13_in_directive395); 
					pushFollow(FOLLOW_argument_in_directive397);
					argument8=argument();
					state._fsp--;


					        try {
					            ret = new CdataDirective(argument8.toString());
					        } catch (final XmlContentException ex) {
					            throw new ParsingException(ex);
					        }
					    
					}
					break;
				case 14 :
					// org/xembly/Xembly.g:167:5: 'COMMENT' argument
					{
					match(input,14,FOLLOW_14_in_directive415); 
					pushFollow(FOLLOW_argument_in_directive417);
					argument9=argument();
					state._fsp--;


					        try {
					            ret = new CommentDirective(argument9.toString());
					        } catch (final XmlContentException ex) {
					            throw new ParsingException(ex);
					        }
					    
					}
					break;

			}
		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "directive"



	// $ANTLR start "argument"
	// org/xembly/Xembly.g:177:1: argument returns [Object ret] : TEXT ;
	public final Object argument() throws RecognitionException {
		Object ret = null;


		Token TEXT10=null;

		try {
			// org/xembly/Xembly.g:178:5: ( TEXT )
			// org/xembly/Xembly.g:179:5: TEXT
			{
			TEXT10=(Token)match(input,TEXT,FOLLOW_TEXT_in_argument448); 
			 ret = (TEXT10!=null?TEXT10.getText():null); 
			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
		return ret;
	}
	// $ANTLR end "argument"



	// $ANTLR start "label"
	// org/xembly/Xembly.g:183:1: label : ( DIGIT )+ ;
	public final void label() throws RecognitionException {
		try {
			// org/xembly/Xembly.g:184:5: ( ( DIGIT )+ )
			// org/xembly/Xembly.g:185:5: ( DIGIT )+
			{
			// org/xembly/Xembly.g:185:5: ( DIGIT )+
			int cnt4=0;
			loop4:
			while (true) {
				int alt4=2;
				int LA4_0 = input.LA(1);
				if ( (LA4_0==DIGIT) ) {
					alt4=1;
				}

				switch (alt4) {
				case 1 :
					// org/xembly/Xembly.g:185:5: DIGIT
					{
					match(input,DIGIT,FOLLOW_DIGIT_in_label475); 
					}
					break;

				default :
					if ( cnt4 >= 1 ) break loop4;
					EarlyExitException eee = new EarlyExitException(4, input);
					throw eee;
				}
				cnt4++;
			}

			}

		}
		catch (RecognitionException re) {
			reportError(re);
			recover(input,re);
		}
		finally {
			// do for sure before leaving
		}
	}
	// $ANTLR end "label"

	// Delegated rules



	public static final BitSet FOLLOW_label_in_directives77 = new BitSet(new long[]{0x0000000000000010L});
	public static final BitSet FOLLOW_COLON_in_directives79 = new BitSet(new long[]{0x0000000000FFFC00L});
	public static final BitSet FOLLOW_directive_in_directives91 = new BitSet(new long[]{0x0000000000000080L});
	public static final BitSet FOLLOW_SEMICOLON_in_directives101 = new BitSet(new long[]{0x0000000000FFFC40L});
	public static final BitSet FOLLOW_EOF_in_directives124 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_22_in_directive149 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_argument_in_directive151 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_19_in_directive169 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_argument_in_directive171 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_23_in_directive189 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_argument_in_directive191 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_12_in_directive209 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_argument_in_directive213 = new BitSet(new long[]{0x0000000000000020L});
	public static final BitSet FOLLOW_COMMA_in_directive215 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_argument_in_directive219 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_10_in_directive237 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_argument_in_directive239 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_11_in_directive257 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_argument_in_directive259 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_18_in_directive277 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_20_in_directive295 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_argument_in_directive297 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_21_in_directive315 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_15_in_directive333 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_argument_in_directive337 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_argument_in_directive341 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_17_in_directive359 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_16_in_directive377 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_13_in_directive395 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_argument_in_directive397 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_14_in_directive415 = new BitSet(new long[]{0x0000000000000200L});
	public static final BitSet FOLLOW_argument_in_directive417 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_TEXT_in_argument448 = new BitSet(new long[]{0x0000000000000002L});
	public static final BitSet FOLLOW_DIGIT_in_label475 = new BitSet(new long[]{0x0000000000000042L});
}
