/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import org.xembly.XmlContentException;

final class Arg {
    private final String value;

    Arg(String val) throws XmlContentException {
        this.value = Arg.ifValid(val);
    }

    public String toString() {
        String escaped = Arg.escape(this.value);
        return new StringBuilder(this.value.length() + 2 + escaped.length()).append('\"').append(escaped).append('\"').toString();
    }

    public String raw() {
        return this.value;
    }

    public static String unescape(String text) throws XmlContentException {
        char[] chars = text.toCharArray();
        if (chars.length < 2) {
            throw new IllegalArgumentException("Internal error, argument can't be shorter than 2 chars");
        }
        int len = chars.length - 1;
        StringBuilder output = new StringBuilder(text.length());
        for (int idx = 1; idx < len; ++idx) {
            if (chars[idx] == '&') {
                StringBuilder sbuf = new StringBuilder(0);
                while (chars[idx] != ';') {
                    if (++idx == chars.length) {
                        throw new XmlContentException("Reached EOF while parsing XML symbol");
                    }
                    sbuf.append(chars[idx]);
                }
                output.append(Arg.symbol(sbuf.substring(0, sbuf.length() - 1)));
                continue;
            }
            output.append(chars[idx]);
        }
        return output.toString();
    }

    private static String escape(String text) {
        StringBuilder output = new StringBuilder(text.length());
        for (char chr : text.toCharArray()) {
            if (chr < ' ') {
                output.append("&#").append((int)chr).append(';');
                continue;
            }
            if (chr == '\"') {
                output.append("&quot;");
                continue;
            }
            if (chr == '&') {
                output.append("&amp;");
                continue;
            }
            if (chr == '\'') {
                output.append("&apos;");
                continue;
            }
            if (chr == '<') {
                output.append("&lt;");
                continue;
            }
            if (chr == '>') {
                output.append("&gt;");
                continue;
            }
            output.append(chr);
        }
        return output.toString();
    }

    private static char symbol(String symbol) throws XmlContentException {
        int chr;
        if ('#' == symbol.charAt(0)) {
            int num = Integer.parseInt(symbol.substring(1));
            chr = Arg.legal((char)num);
        } else if ("apos".equalsIgnoreCase(symbol)) {
            chr = 39;
        } else if ("quot".equalsIgnoreCase(symbol)) {
            chr = 34;
        } else if ("lt".equalsIgnoreCase(symbol)) {
            chr = 60;
        } else if ("gt".equalsIgnoreCase(symbol)) {
            chr = 62;
        } else if ("amp".equalsIgnoreCase(symbol)) {
            chr = 38;
        } else {
            throw new XmlContentException(String.format("Unknown XML symbol &%s;", symbol));
        }
        return (char)chr;
    }

    private static char legal(char chr) throws XmlContentException {
        Arg.range(chr, 0, 8);
        Arg.range(chr, 11, 12);
        Arg.range(chr, 14, 31);
        Arg.range(chr, 127, 132);
        Arg.range(chr, 134, 159);
        return chr;
    }

    private static void range(char chr, int left, int right) throws XmlContentException {
        if (chr >= left && chr <= right) {
            throw new XmlContentException(String.format("Character #%02X is in the restricted XML range #%02X-#%02X, see http://www.w3.org/TR/2004/REC-xml11-20040204/#charsets", chr, left, right));
        }
    }

    private static String ifValid(String val) throws XmlContentException {
        for (char chr : val.toCharArray()) {
            Arg.legal(chr);
        }
        return val;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Arg)) {
            return false;
        }
        Arg other = (Arg)o;
        String this$value = this.value;
        String other$value = other.value;
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $value = this.value;
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }
}

