/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xembly.AddDirective;
import org.xembly.AddIfDirective;
import org.xembly.AttrDirective;
import org.xembly.CdataDirective;
import org.xembly.CommentDirective;
import org.xembly.Directive;
import org.xembly.PiDirective;
import org.xembly.PopDirective;
import org.xembly.Print;
import org.xembly.PushDirective;
import org.xembly.RemoveDirective;
import org.xembly.SetDirective;
import org.xembly.StrictDirective;
import org.xembly.UpDirective;
import org.xembly.Verbs;
import org.xembly.XattrDirective;
import org.xembly.XmlContentException;
import org.xembly.XpathDirective;
import org.xembly.XsetDirective;

public final class Directives
implements Iterable<Directive> {
    private final Collection<Directive> all;

    public Directives() {
        this(Collections.emptyList());
    }

    public Directives(String text) {
        this(new Verbs(text).directives());
    }

    public Directives(Iterable<Directive> dirs) {
        this.all = Collections.synchronizedCollection(Directives.toCollection(dirs));
    }

    public String toString() {
        return new Print(this.all).toString();
    }

    @Override
    public Iterator<Directive> iterator() {
        return this.all.iterator();
    }

    public static Iterable<Directive> copyOf(Node node) {
        int idx;
        int len;
        Directives dirs = new Directives();
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            len = attrs.getLength();
            for (idx = 0; idx < len; ++idx) {
                Attr attr = (Attr)Attr.class.cast(attrs.item(idx));
                dirs.attr(attr.getNodeName(), attr.getNodeValue());
            }
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            len = children.getLength();
            block8: for (idx = 0; idx < len; ++idx) {
                Node child = children.item(idx);
                switch (child.getNodeType()) {
                    case 1: {
                        dirs.add(child.getNodeName()).append(Directives.copyOf(child)).up();
                        continue block8;
                    }
                    case 2: {
                        dirs.attr(child.getNodeName(), child.getNodeValue());
                        continue block8;
                    }
                    case 3: 
                    case 4: {
                        if (len == 1) {
                            dirs.set(child.getTextContent());
                            continue block8;
                        }
                        if (child.getTextContent().trim().isEmpty()) continue block8;
                        throw new IllegalArgumentException(String.format("TEXT node #%d is not allowed together with other %d nodes in %s", idx, len, child.getNodeName()));
                    }
                    case 7: {
                        dirs.pi(child.getNodeName(), child.getNodeValue());
                        continue block8;
                    }
                    case 6: 
                    case 8: {
                        continue block8;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("Unsupported type %d of node %s", child.getNodeType(), child.getNodeName()));
                    }
                }
            }
        }
        return dirs;
    }

    public Directives append(Iterable<Directive> dirs) {
        this.all.addAll(Directives.toCollection(dirs));
        return this;
    }

    public Directives append(Node node) {
        return this.append(Directives.copyOf(node));
    }

    public Directives add(Object name) {
        try {
            this.all.add(new AddDirective(name.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("Failed to understand XML content, ADD(%s)", name), ex);
        }
        return this;
    }

    public <K, V> Directives add(Map<K, V> nodes) {
        for (Map.Entry<K, V> entry : nodes.entrySet()) {
            this.add(entry.getKey().toString()).set(entry.getValue().toString()).up();
        }
        return this;
    }

    public Directives addIf(Object name) {
        try {
            this.all.add(new AddIfDirective(name.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("Failed to understand XML content, ADDIF(%s)", name), ex);
        }
        return this;
    }

    public Directives remove() {
        this.all.add(new RemoveDirective());
        return this;
    }

    public Directives attr(Object name, Object value) {
        try {
            this.all.add(new AttrDirective(name.toString(), value.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("Failed to understand XML content, ATTR(%s, %s)", name, value), ex);
        }
        return this;
    }

    public Directives pi(Object target, Object data) {
        try {
            this.all.add(new PiDirective(target.toString(), data.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("Failed to understand XML content, PI(%s, %s)", target, data), ex);
        }
        return this;
    }

    public Directives set(Object text) {
        try {
            this.all.add(new SetDirective(text.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("Failed to understand XML content, SET(%s)", text), ex);
        }
        return this;
    }

    public Directives xset(Object text) {
        try {
            this.all.add(new XsetDirective(text.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("Failed to understand XML content, XSET(%s)", text), ex);
        }
        return this;
    }

    public Directives xattr(Object attr, Object text) {
        try {
            this.all.add(new XattrDirective(attr.toString(), text.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("Failed to understand XML content, XATTR(%s, %s)", attr, text), ex);
        }
        return this;
    }

    public Directives up() {
        this.all.add(new UpDirective());
        return this;
    }

    public Directives xpath(Object path) {
        try {
            this.all.add(new XpathDirective(path.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("Failed to understand XML content, XPATH(%s)", path), ex);
        }
        return this;
    }

    public Directives strict(int number) {
        this.all.add(new StrictDirective(number));
        return this;
    }

    public Directives push() {
        this.all.add(new PushDirective());
        return this;
    }

    public Directives pop() {
        this.all.add(new PopDirective());
        return this;
    }

    public Directives cdata(Object text) {
        try {
            this.all.add(new CdataDirective(text.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("Failed to understand XML content, CDATA(%s)", text), ex);
        }
        return this;
    }

    public Directives comment(Object text) {
        try {
            this.all.add(new CommentDirective(text.toString()));
        }
        catch (XmlContentException ex) {
            throw new IllegalArgumentException(String.format("Failed to understand XML content, comment(%s)", text), ex);
        }
        return this;
    }

    private static <T> Collection<T> toCollection(Iterable<T> itr) {
        LinkedList<T> col = new LinkedList<T>();
        for (T item : itr) {
            col.add(item);
        }
        return col;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Directives)) {
            return false;
        }
        Directives other = (Directives)o;
        Collection<Directive> this$all = this.all;
        Collection<Directive> other$all = other.all;
        return !(this$all == null ? other$all != null : !((Object)this$all).equals(other$all));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<Directive> $all = this.all;
        result = result * 59 + ($all == null ? 43 : ((Object)$all).hashCode());
        return result;
    }
}

