/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import java.util.Locale;
import lombok.Generated;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.xembly.Arg;
import org.xembly.Directive;
import org.xembly.XmlContentException;

final class PiDirective
implements Directive {
    private final Arg target;
    private final Arg data;

    PiDirective(String tgt, String dat) throws XmlContentException {
        this.target = new Arg(tgt.toLowerCase(Locale.ENGLISH));
        this.data = new Arg(dat);
    }

    public String toString() {
        return String.format("PI %s, %s", this.target, this.data);
    }

    @Override
    public Directive.Cursor exec(Node dom, Directive.Cursor cursor, Directive.Stack stack) {
        Document doc = dom.getOwnerDocument() == null ? (Document)Document.class.cast(dom) : dom.getOwnerDocument();
        ProcessingInstruction instr = doc.createProcessingInstruction(this.target.raw(), this.data.raw());
        if (cursor.isEmpty()) {
            dom.insertBefore(instr, doc.getDocumentElement());
        } else {
            for (Node node : cursor) {
                node.appendChild(instr);
            }
        }
        return cursor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PiDirective)) {
            return false;
        }
        PiDirective other = (PiDirective)o;
        Arg this$target = this.target;
        Arg other$target = other.target;
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        Arg this$data = this.data;
        Arg other$data = other.data;
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Arg $target = this.target;
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        Arg $data = this.data;
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }
}

