/*
 * Decompiled with CFR 0.152.
 */
package org.xembly;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import lombok.Generated;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xembly.Arg;
import org.xembly.Directive;
import org.xembly.ImpossibleModificationException;
import org.xembly.XmlContentException;

final class XattrDirective
implements Directive {
    private static final XPathFactory FACTORY = XPathFactory.newInstance();
    private final Arg name;
    private final Arg expr;

    XattrDirective(String attr, String val) throws XmlContentException {
        this.name = new Arg(attr);
        this.expr = new Arg(val);
    }

    public String toString() {
        return String.format("XATTR %s, %s", this.name, this.expr);
    }

    @Override
    public Directive.Cursor exec(Node dom, Directive.Cursor cursor, Directive.Stack stack) throws ImpossibleModificationException {
        ConcurrentHashMap<Node, String> values = new ConcurrentHashMap<Node, String>(0);
        XPath xpath = FACTORY.newXPath();
        for (Node node : cursor) {
            try {
                values.put(node, xpath.evaluate(this.expr.raw(), node, XPathConstants.STRING).toString());
            }
            catch (XPathExpressionException ex) {
                throw new ImpossibleModificationException(String.format("Invalid XPath expr '%s'", this.expr), ex);
            }
        }
        for (Map.Entry entry : values.entrySet()) {
            ((Element)Element.class.cast(entry.getKey())).setAttribute(this.name.raw(), (String)entry.getValue());
        }
        return cursor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XattrDirective)) {
            return false;
        }
        XattrDirective other = (XattrDirective)o;
        Arg this$expr = this.expr;
        Arg other$expr = other.expr;
        return !(this$expr == null ? other$expr != null : !((Object)this$expr).equals(other$expr));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Arg $expr = this.expr;
        result = result * 59 + ($expr == null ? 43 : ((Object)$expr).hashCode());
        return result;
    }
}

