/**
 * Copyright (c) 2012-2015, jcabi.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met: 1) Redistributions of source code must retain the above
 * copyright notice, this list of conditions and the following
 * disclaimer. 2) Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided
 * with the distribution. 3) Neither the name of the jcabi.com nor
 * the names of its contributors may be used to endorse or promote
 * products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.jcabi.aspects.version;

/**
 * Current version of the project. Generated from a template at build time.
 * @author Georgy Vlasov (wlasowegor@gmail.com)
 * @version $Id: 904076be99f7d97fb13525867f4ca83d5daa899d $
 * @since 0.23
 */
public enum Version {
    /**
     * Current version.
     */
    CURRENT("0.22.3", "eb12ab2");

    /**
     * Project version.
     */
    private final String version;

    /**
     * Build number.
     */
    private final String build;

    /**
     * Public ctor.
     * @param ver Maven's project.version property
     * @param buildnum Maven's buildNumber property created with
     *  buildnumber-maven-plugin
     */
    Version(final String ver, final String buildnum) {
        this.version = ver;
        this.build = buildnum;
    }

    /**
     * Returns project version number.
     * @return Project version number
     */
    public String projectVersion() {
        return this.version;
    }

    /**
     * Returns project build number.
     * @return Build number
     */
    public String buildNumber() {
        return this.build;
    }
}
