/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.aj;

import com.jcabi.aspects.aj.ImprovedJoinPoint;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Set;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.Validator;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.ConstructorSignature;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public final class MethodValidator {
    private final transient Validator validator = Validation.buildDefaultValidatorFactory().getValidator();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MethodValidator ajc$perSingletonInstance;

    @Before(value="execution(* *(.., @(javax.validation.* || javax.validation.constraints.*) (*), ..))")
    public void beforeMethod(JoinPoint point) {
        if (this.validator != null) {
            this.validateMethod(point.getThis(), ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod(), point.getArgs());
        }
    }

    @Before(value="preinitialization(*.new(.., @(javax.validation.* || javax.validation.constraints.*) (*), ..))")
    public void beforeCtor(JoinPoint point) {
        if (this.validator != null) {
            Constructor constructor = ((ConstructorSignature)ConstructorSignature.class.cast(point.getSignature())).getConstructor();
            this.validateConstructor(constructor, point.getArgs());
        }
    }

    @AfterReturning(pointcut="execution(@(javax.validation.* || javax.validation.constraints.*) * *(..))", returning="result")
    public void after(JoinPoint point, Object result) {
        this.checkForViolations(this.validator.forExecutables().validateReturnValue(point.getThis(), new ImprovedJoinPoint(point).currentMethod(), result, new Class[0]));
    }

    private void validateMethod(Object object, Method method, Object ... args) {
        block2: {
            try {
                this.checkForViolations(this.validator.forExecutables().validateParameters(object, method, args, new Class[0]));
            }
            catch (ConstraintDeclarationException ex) {
                if (ex.getMessage().startsWith("HV000151")) break block2;
                throw new ConstraintDeclarationException((Throwable)ex);
            }
        }
    }

    private void validateConstructor(Constructor<Object> ctr, Object ... args) {
        this.checkForViolations(this.validator.forExecutables().validateConstructorParameters(ctr, args, new Class[0]));
    }

    private void checkForViolations(Set<ConstraintViolation<Object>> violations) {
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(MethodValidator.pack(violations), violations);
        }
    }

    private static String pack(Collection<ConstraintViolation<Object>> errs) {
        StringBuilder text = new StringBuilder(0);
        for (ConstraintViolation<Object> violation : errs) {
            if (text.length() > 0) {
                text.append("; ");
            }
            text.append(violation.getMessage());
        }
        return text.toString();
    }

    public static MethodValidator aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.jcabi.aspects.aj.MethodValidator", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            MethodValidator.ajc$perSingletonInstance = new MethodValidator();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

