/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.aj;

import com.jcabi.aspects.version.Version;
import com.jcabi.log.Logger;
import java.util.concurrent.ThreadFactory;

final class NamedThreads
implements ThreadFactory {
    private final transient String name;
    private final transient String purpose;
    private final transient ThreadGroup group;

    public NamedThreads(String suffix, String desc) {
        this.name = String.format("jcabi-%s", suffix);
        this.purpose = desc;
        this.group = new ThreadGroup("jcabi");
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = new Thread(this.group, runnable);
        thread.setName(this.name);
        thread.setDaemon(true);
        Logger.info((Object)this, (String)"jcabi-aspects %s/%s started new daemon thread %s for %s", (Object[])new Object[]{Version.CURRENT.projectVersion(), Version.CURRENT.buildNumber(), this.name, this.purpose});
        return thread;
    }
}

