/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.aj;

import com.jcabi.aspects.Cacheable;
import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.LogHelper;
import com.jcabi.aspects.aj.Mnemos;
import com.jcabi.aspects.aj.UpdateMethodCacher;
import com.jcabi.log.Logger;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public final class MethodCacher {
    private final ConcurrentMap<Key, Tunnel> tunnels = new ConcurrentHashMap<Key, Tunnel>(0);
    private final BlockingQueue<Key> updatekeys = new LinkedBlockingQueue<Key>();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MethodCacher ajc$perSingletonInstance;

    public MethodCacher() {
        new UpdateMethodCacher(this.tunnels, this.updatekeys).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* *(..)) && @annotation(com.jcabi.aspects.Cacheable)")
    public Object cache(ProceedingJoinPoint point) throws Throwable {
        Tunnel tunnel;
        Key key = new Key((JoinPoint)point);
        Method method = ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod();
        Cacheable annot = method.getAnnotation(Cacheable.class);
        ConcurrentMap<Key, Tunnel> concurrentMap = this.tunnels;
        synchronized (concurrentMap) {
            boolean flag;
            Class<?>[] classArray = annot.before();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> before = classArray[n2];
                flag = (Boolean)Boolean.class.cast(before.getMethod("flushBefore", new Class[0]).invoke(method.getClass(), new Object[0]));
                if (flag) {
                    this.preflush((JoinPoint)point);
                }
                ++n2;
            }
            tunnel = (Tunnel)this.tunnels.get(key);
            if (MethodCacher.isCreateTunnel(tunnel)) {
                tunnel = new Tunnel(point, key, annot.asyncUpdate());
                this.tunnels.put(key, tunnel);
            }
            if (tunnel.expired() && tunnel.asyncUpdate()) {
                this.updatekeys.offer(key);
            }
            classArray = annot.after();
            n = classArray.length;
            n2 = 0;
            while (n2 < n) {
                Class<?> after = classArray[n2];
                flag = (Boolean)Boolean.class.cast(after.getMethod("flushAfter", new Class[0]).invoke(method.getClass(), new Object[0]));
                if (flag) {
                    this.postflush((JoinPoint)point);
                }
                ++n2;
            }
        }
        return tunnel.through();
    }

    @Deprecated
    public Object flush(ProceedingJoinPoint point) throws Throwable {
        this.preflush((JoinPoint)point);
        return point.proceed();
    }

    @Before(value="execution(* *(..)) && (@annotation(com.jcabi.aspects.Cacheable.Flush) || @annotation(com.jcabi.aspects.Cacheable.FlushBefore))")
    public void preflush(JoinPoint point) {
        this.flush(point, "before the call");
    }

    @After(value="execution(* *(..)) && @annotation(com.jcabi.aspects.Cacheable.FlushAfter)")
    public void postflush(JoinPoint point) {
        this.flush(point, "after the call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(JoinPoint point, String when) {
        ConcurrentMap<Key, Tunnel> concurrentMap = this.tunnels;
        synchronized (concurrentMap) {
            for (Key key : this.tunnels.keySet()) {
                if (!key.sameTarget(point)) continue;
                Tunnel removed = (Tunnel)this.tunnels.remove(key);
                Method method = ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod();
                if (!LogHelper.enabled(key.getLevel(), method.getDeclaringClass())) continue;
                LogHelper.log(key.getLevel(), method.getDeclaringClass(), "%s: %s:%s removed from cache %s", Mnemos.toText(method, point.getArgs(), true, false), key, removed, when);
            }
        }
    }

    private static boolean isCreateTunnel(Tunnel tunnel) {
        return tunnel == null || tunnel.expired() && !tunnel.asyncUpdate();
    }

    public static MethodCacher aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.jcabi.aspects.aj.MethodCacher", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            MethodCacher.ajc$perSingletonInstance = new MethodCacher();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    protected static class Key {
        private final transient long start = System.currentTimeMillis();
        private final transient AtomicInteger accessed = new AtomicInteger();
        private final transient Method method;
        private final transient Object target;
        private final transient Object[] arguments;
        private final int level;

        Key(JoinPoint point) {
            this.method = ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod();
            this.target = Key.targetize(point);
            this.arguments = point.getArgs();
            this.level = this.method.isAnnotationPresent(Loggable.class) ? this.method.getAnnotation(Loggable.class).value() : 1;
        }

        public final int getLevel() {
            return this.level;
        }

        public final String toString() {
            return Mnemos.toText(this.method, this.arguments, true, false);
        }

        public final int hashCode() {
            return this.method.hashCode();
        }

        public final boolean equals(Object obj) {
            boolean equals;
            if (this == obj) {
                equals = true;
            } else if (obj instanceof Key) {
                Key key = (Key)Key.class.cast(obj);
                equals = key.method.equals(this.method) && this.target.equals(key.target) && Arrays.deepEquals(key.arguments, this.arguments);
            } else {
                equals = false;
            }
            return equals;
        }

        public Object through(Object result) {
            int hit = this.accessed.getAndIncrement();
            Class<?> type = this.method.getDeclaringClass();
            if (hit > 0 && LogHelper.enabled(this.level, type)) {
                LogHelper.log(this.level, type, "%s: %s from cache (hit #%d, %[ms]s old)", this, Mnemos.toText(result, true, false), hit, System.currentTimeMillis() - this.start);
            }
            return result;
        }

        public final boolean sameTarget(JoinPoint point) {
            return Key.targetize(point).equals(this.target);
        }

        private static Object targetize(JoinPoint point) {
            Method method = ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod();
            Object tgt = Modifier.isStatic(method.getModifiers()) ? method.getDeclaringClass() : point.getTarget();
            return tgt;
        }
    }

    protected static final class Tunnel {
        private final transient ProceedingJoinPoint point;
        private final transient Key key;
        private final transient boolean async;
        private transient boolean executed;
        private transient long lifetime;
        private transient boolean hasresult;
        private transient SoftReference<Object> cached;

        Tunnel(ProceedingJoinPoint pnt, Key akey, boolean asy) {
            this.point = pnt;
            this.key = akey;
            this.async = asy;
        }

        public String toString() {
            return Mnemos.toText(this.cached.get(), true, false);
        }

        public Tunnel copy() {
            return new Tunnel(this.point, this.key, this.async);
        }

        public synchronized Object through() throws Throwable {
            if (!this.executed) {
                String suffix;
                long start = System.currentTimeMillis();
                Object result = this.point.proceed();
                this.hasresult = result != null;
                this.cached = new SoftReference<Object>(result);
                Method method = ((MethodSignature)MethodSignature.class.cast(this.point.getSignature())).getMethod();
                Cacheable annot = method.getAnnotation(Cacheable.class);
                if (annot.forever()) {
                    this.lifetime = Long.MAX_VALUE;
                    suffix = "valid forever";
                } else if (annot.lifetime() == 0) {
                    this.lifetime = 0L;
                    suffix = "invalid immediately";
                } else {
                    long msec = annot.unit().toMillis(annot.lifetime());
                    this.lifetime = start + msec;
                    suffix = Logger.format((String)"valid for %[ms]s", (Object[])new Object[]{msec});
                }
                Class<?> type = method.getDeclaringClass();
                if (LogHelper.enabled(this.key.getLevel(), type)) {
                    LogHelper.log(this.key.getLevel(), type, "%s: %s cached in %[ms]s, %s", Mnemos.toText(method, this.point.getArgs(), true, false), Mnemos.toText(this.cached.get(), true, false), System.currentTimeMillis() - start, suffix);
                }
                this.executed = true;
            }
            return this.key.through(this.cached.get());
        }

        public boolean expired() {
            boolean collected;
            boolean expired = this.lifetime < System.currentTimeMillis();
            boolean bl = collected = this.executed && this.hasresult && this.cached.get() == null;
            return this.executed && (expired || collected);
        }

        public boolean asyncUpdate() {
            return this.async;
        }

        SoftReference<Object> cached() {
            return this.cached;
        }
    }
}

