/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.aj;

import com.jcabi.aspects.Cacheable;
import com.jcabi.aspects.aj.Mnemos;
import com.jcabi.aspects.aj.NamedThreads;
import com.jcabi.log.Logger;
import com.jcabi.log.VerboseRunnable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public final class MethodCacher {
    private final transient ConcurrentMap<Key, Tunnel> tunnels = new ConcurrentHashMap<Key, Tunnel>();
    private final transient ScheduledExecutorService cleaner = Executors.newSingleThreadScheduledExecutor(new NamedThreads("cacheable", "automated cleaning of expired @Cacheable values"));
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MethodCacher ajc$perSingletonInstance;

    public MethodCacher() {
        this.cleaner.scheduleWithFixedDelay((Runnable)new VerboseRunnable(new Runnable(){

            @Override
            public void run() {
                MethodCacher.this.clean();
            }
        }), 1L, 1L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* *(..)) && @annotation(com.jcabi.aspects.Cacheable)")
    public Object cache(ProceedingJoinPoint point) throws Throwable {
        Tunnel tunnel;
        Key key = new Key(point);
        ConcurrentMap concurrentMap = this.tunnels;
        synchronized (concurrentMap) {
            tunnel = (Tunnel)this.tunnels.get(key);
            if (tunnel == null || tunnel.expired()) {
                tunnel = new Tunnel(point, key);
                this.tunnels.put(key, tunnel);
            }
        }
        return tunnel.through();
    }

    @Deprecated
    public Object flush(ProceedingJoinPoint point) throws Throwable {
        this.preflush((JoinPoint)point);
        return point.proceed();
    }

    @Before(value="execution(* *(..)) && (@annotation(com.jcabi.aspects.Cacheable.Flush) || @annotation(com.jcabi.aspects.Cacheable.FlushBefore))")
    public void preflush(JoinPoint point) {
        this.flush(point, "before the call");
    }

    @After(value="execution(* *(..)) && @annotation(com.jcabi.aspects.Cacheable.FlushAfter)")
    public void postflush(JoinPoint point) {
        this.flush(point, "after the call");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(JoinPoint point, String when) {
        ConcurrentMap<Key, Tunnel> concurrentMap = this.tunnels;
        synchronized (concurrentMap) {
            for (Key key : this.tunnels.keySet()) {
                if (!key.sameTarget(point)) continue;
                Tunnel removed = (Tunnel)this.tunnels.remove(key);
                Method method = ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod();
                if (!Logger.isDebugEnabled(method.getDeclaringClass())) continue;
                Logger.debug(method.getDeclaringClass(), (String)"%s: %s:%s removed from cache %s", (Object[])new Object[]{Mnemos.toText(method, point.getArgs(), true, false), key, removed, when});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clean() {
        ConcurrentMap<Key, Tunnel> concurrentMap = this.tunnels;
        synchronized (concurrentMap) {
            for (Key key : this.tunnels.keySet()) {
                if (!((Tunnel)this.tunnels.get(key)).expired()) continue;
                Tunnel tunnel = (Tunnel)this.tunnels.remove(key);
                Logger.debug((Object)this, (String)"%s:%s expired in cache", (Object[])new Object[]{key, tunnel});
            }
        }
    }

    public static MethodCacher aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.jcabi.aspects.aj.MethodCacher", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            MethodCacher.ajc$perSingletonInstance = new MethodCacher();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    private static final class Key {
        private final transient long start = System.currentTimeMillis();
        private final transient AtomicInteger accessed = new AtomicInteger();
        private final transient Method method;
        private final transient Object target;
        private final transient Object[] arguments;

        public Key(ProceedingJoinPoint point) {
            this.method = ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod();
            this.target = Key.targetize((JoinPoint)point);
            this.arguments = point.getArgs();
        }

        public String toString() {
            return Mnemos.toText(this.method, this.arguments, true, false);
        }

        public int hashCode() {
            return this.method.hashCode();
        }

        public boolean equals(Object obj) {
            boolean equals;
            if (this == obj) {
                equals = true;
            } else if (obj instanceof Key) {
                Key key = (Key)Key.class.cast(obj);
                equals = key.method.equals(this.method) && this.target.equals(key.target) && Arrays.deepEquals(key.arguments, this.arguments);
            } else {
                equals = false;
            }
            return equals;
        }

        public Object through(Object result) {
            int hit = this.accessed.getAndIncrement();
            Class<?> type = this.method.getDeclaringClass();
            if (hit > 0 && Logger.isDebugEnabled(type)) {
                Logger.debug(type, (String)"%s: %s from cache (hit #%d, %[ms]s old)", (Object[])new Object[]{this, Mnemos.toText(result, true, false), hit, System.currentTimeMillis() - this.start});
            }
            return result;
        }

        public boolean sameTarget(JoinPoint point) {
            return Key.targetize(point).equals(this.target);
        }

        private static Object targetize(JoinPoint point) {
            Method method = ((MethodSignature)MethodSignature.class.cast(point.getSignature())).getMethod();
            Object tgt = Modifier.isStatic(method.getModifiers()) ? method.getDeclaringClass() : point.getTarget();
            return tgt;
        }
    }

    private static final class Tunnel {
        private final transient ProceedingJoinPoint point;
        private final transient Key key;
        private transient boolean executed;
        private transient long lifetime;
        private transient Object cached;

        public Tunnel(ProceedingJoinPoint pnt, Key akey) {
            this.point = pnt;
            this.key = akey;
        }

        public String toString() {
            return Mnemos.toText(this.cached, true, false);
        }

        public synchronized Object through() throws Throwable {
            if (!this.executed) {
                String suffix;
                long start = System.currentTimeMillis();
                this.cached = this.point.proceed();
                Method method = ((MethodSignature)MethodSignature.class.cast(this.point.getSignature())).getMethod();
                Cacheable annot = method.getAnnotation(Cacheable.class);
                if (annot.forever()) {
                    this.lifetime = Long.MAX_VALUE;
                    suffix = "valid forever";
                } else if (annot.lifetime() == 0) {
                    this.lifetime = 0L;
                    suffix = "invalid immediately";
                } else {
                    long msec = annot.unit().toMillis(annot.lifetime());
                    this.lifetime = start + msec;
                    suffix = Logger.format((String)"valid for %[ms]s", (Object[])new Object[]{msec});
                }
                Class<?> type = method.getDeclaringClass();
                if (Logger.isDebugEnabled(type)) {
                    Logger.debug(type, (String)"%s: %s cached in %[ms]s, %s", (Object[])new Object[]{Mnemos.toText(method, this.point.getArgs(), true, false), Mnemos.toText(this.cached, true, false), System.currentTimeMillis() - start, suffix});
                }
                this.executed = true;
            }
            return this.key.through(this.cached);
        }

        public boolean expired() {
            return this.executed && this.lifetime < System.currentTimeMillis();
        }
    }
}

