/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.aspects.aj;

import com.jcabi.aspects.ScheduleWithFixedDelay;
import com.jcabi.log.Logger;
import com.jcabi.log.VerboseRunnable;
import com.jcabi.log.VerboseThreads;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

@Aspect
public final class MethodScheduler {
    private final transient ConcurrentMap<Object, Service> services = new ConcurrentHashMap<Object, Service>();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MethodScheduler ajc$perSingletonInstance;

    @After(value="initialization((@com.jcabi.aspects.ScheduleWithFixedDelay *).new(..))")
    public void instantiate(JoinPoint point) {
        VerboseRunnable runnable;
        Object object = point.getTarget();
        if (this.services.containsKey(object)) {
            throw new IllegalStateException(Logger.format((String)"%[type]s was already scheduled for execution", (Object[])new Object[]{object}));
        }
        if (object instanceof Runnable) {
            runnable = new VerboseRunnable((Runnable)Runnable.class.cast(object), true);
        } else if (object instanceof Callable) {
            runnable = new VerboseRunnable((Callable)Callable.class.cast(object), true);
        } else {
            throw new IllegalStateException(Logger.format((String)"%[type]s doesn't implement Runnable or Callable", (Object[])new Object[]{object}));
        }
        this.services.put(object, new Service((Runnable)runnable, object, object.getClass().getAnnotation(ScheduleWithFixedDelay.class)));
    }

    @Before(value="execution(* (@com.jcabi.aspects.ScheduleWithFixedDelay *).close())")
    public void close(JoinPoint point) throws IOException {
        Object object = point.getTarget();
        ((Service)this.services.get(object)).close();
        this.services.remove(object);
    }

    public static MethodScheduler aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.jcabi.aspects.aj.MethodScheduler", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            MethodScheduler.ajc$perSingletonInstance = new MethodScheduler();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    private static final class Service
    implements Closeable {
        private final transient ScheduledExecutorService executor;
        private final transient Object object;
        private final transient AtomicLong counter = new AtomicLong();
        private final transient long start = System.currentTimeMillis();

        public Service(final Runnable runnable, Object obj, ScheduleWithFixedDelay annt) {
            this.object = obj;
            this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new VerboseThreads(this.object));
            this.executor.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    runnable.run();
                    Service.this.counter.incrementAndGet();
                }
            }, annt.delay(), annt.delay(), annt.unit());
            Logger.info((Object)this.object, (String)"scheduled for execution with %d %s interval", (Object[])new Object[]{annt.delay(), annt.unit()});
        }

        @Override
        public void close() throws IOException {
            this.executor.shutdown();
            if (!this.terminated()) {
                this.executor.shutdownNow();
                if (!this.terminated()) {
                    throw new IllegalStateException(Logger.format((String)"failed to shutdown %[type]s of %[type]s", (Object[])new Object[]{this.executor, this.object}));
                }
            }
            Logger.info((Object)this.object, (String)"execution stopped after %[ms]s and %d tick(s)", (Object[])new Object[]{System.currentTimeMillis() - this.start, this.counter.get()});
        }

        private boolean terminated() {
            try {
                return this.executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(ex);
            }
        }
    }
}

