/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.beanstalk.maven.plugin;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.jcabi.beanstalk.maven.plugin.Application;
import com.jcabi.beanstalk.maven.plugin.Bundle;
import com.jcabi.beanstalk.maven.plugin.DeploymentException;
import com.jcabi.beanstalk.maven.plugin.Environment;
import com.jcabi.beanstalk.maven.plugin.OverridingBundle;
import com.jcabi.beanstalk.maven.plugin.OverridingVersion;
import com.jcabi.beanstalk.maven.plugin.ServerCredentials;
import com.jcabi.beanstalk.maven.plugin.Version;
import com.jcabi.beanstalk.maven.plugin.WarFile;
import com.jcabi.log.Logger;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipFile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.settings.Settings;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.slf4j.impl.StaticLoggerBinder;

abstract class AbstractBeanstalkMojo
extends AbstractMojo {
    @MojoParameter(expression="${settings}", required=true, readonly=true, description="Maven settings.xml reference")
    private transient Settings settings;
    @MojoParameter(defaultValue="false", required=false, description="Skips execution")
    private transient boolean skip;
    @MojoParameter(defaultValue="aws.amazon.com", required=false, description="ID of the server to deploy to, from settings.xml")
    private transient String server;
    @MojoParameter(required=true, description="EBT application name, environment name, and CNAME")
    private transient String name;
    @MojoParameter(required=true, description="Amazon S3 bucket name where to upload WAR file")
    private transient String bucket;
    @MojoParameter(required=true, description="Amazon S3 bucket key where to upload WAR file")
    private transient String key;
    @MojoParameter(required=true, description="Amazon Elastic Beanstalk configuration template name")
    private transient String template;
    @MojoParameter(defaultValue="${project.build.directory}/${project.build.finalName}.war", required=false, description="Location of .WAR file to deploy")
    private transient File war;

    AbstractBeanstalkMojo() {
    }

    public void setSkip(boolean skp) {
        this.skip = skp;
    }

    public void execute() throws MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        if (this.skip) {
            Logger.info((Object)((Object)this), (String)"execution skipped because of 'skip' option");
            return;
        }
        if (!this.war.exists()) {
            throw new MojoFailureException(String.format("WAR file '%s' doesn't exist", this.war));
        }
        try {
            new WarFile(new ZipFile(this.war)).checkEbextensionsValidity();
        }
        catch (IOException ex) {
            throw new MojoFailureException(".ebextensions validity check failed", (Throwable)ex);
        }
        ServerCredentials creds = this.createServerCredentials();
        AWSElasticBeanstalkClient ebt = new AWSElasticBeanstalkClient((AWSCredentials)creds);
        try {
            this.exec(new Application((AWSElasticBeanstalk)ebt, this.name), new OverridingVersion((AWSElasticBeanstalk)ebt, this.name, new Bundle.Safe(new OverridingBundle((AmazonS3)new AmazonS3Client((AWSCredentials)creds), this.bucket, this.key, this.war))), this.template);
        }
        catch (DeploymentException ex) {
            throw new MojoFailureException("failed to deploy", (Throwable)ex);
        }
        finally {
            ebt.shutdown();
        }
    }

    protected ServerCredentials createServerCredentials() throws MojoFailureException {
        return new ServerCredentials(this.settings, this.server);
    }

    protected abstract void exec(Application var1, Version var2, String var3);

    protected void postMortem(Environment env) {
        Logger.error((Object)((Object)this), (String)"Failed to deploy to '%s'", (Object[])new Object[]{env});
        if (!env.terminated()) {
            Logger.error((Object)((Object)this), (String)"TAIL report should explain the cause of failure:");
            this.log(env.tail().split("\n"));
        }
        Logger.error((Object)((Object)this), (String)"Latest EBT events (in reverse order):");
        this.log(env.events());
        env.terminate();
    }

    protected boolean isGreen(Environment env) {
        boolean green = env.green();
        long start = System.currentTimeMillis();
        while (!green) {
            long age = System.currentTimeMillis() - start;
            if (age > TimeUnit.MINUTES.toMillis(15L)) {
                Logger.warn((Object)((Object)this), (String)"Waiting for %[ms]s, time to give up", (Object[])new Object[]{age});
                break;
            }
            Logger.warn((Object)((Object)this), (String)"%s is not GREEN yet, let's wait another 15 second...", (Object[])new Object[]{env});
            try {
                TimeUnit.SECONDS.sleep(15L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new DeploymentException(ex);
            }
            green = env.green();
        }
        return green;
    }

    private void log(String[] lines) {
        for (String line : lines) {
            Logger.info((Object)((Object)this), (String)">> %s", (Object[])new Object[]{line});
        }
    }
}

