/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.beanstalk.maven.plugin;

import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.SwapEnvironmentCNAMEsRequest;
import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.MethodLogger;
import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.beanstalk.maven.plugin.Application$AjcClosure1;
import com.jcabi.beanstalk.maven.plugin.Application$AjcClosure3;
import com.jcabi.beanstalk.maven.plugin.Application$AjcClosure5;
import com.jcabi.beanstalk.maven.plugin.Application$AjcClosure7;
import com.jcabi.beanstalk.maven.plugin.Application$AjcClosure9;
import com.jcabi.beanstalk.maven.plugin.DeploymentException;
import com.jcabi.beanstalk.maven.plugin.Environment;
import com.jcabi.beanstalk.maven.plugin.Version;
import com.jcabi.log.Logger;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Random;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

@Loggable(value=1)
final class Application {
    private final transient AWSElasticBeanstalk client;
    private final transient String name;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    protected Application(@NotNull AWSElasticBeanstalk clnt, @NotNull String app) {
        AWSElasticBeanstalk aWSElasticBeanstalk = clnt;
        String string = app;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)aWSElasticBeanstalk, (Object)string);
        MethodValidator.aspectOf().beforeCtor(joinPoint);
        this.client = clnt;
        this.name = app;
        Logger.info(Application.class, (String)"Working with application '%s'", (Object[])new Object[]{this.name});
    }

    public void clean(boolean wipe) {
        boolean bl = wipe;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
            MethodLogger.aspectOf().wrapClass(new Application$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        Application.clean_aroundBody0(this, bl, joinPoint);
    }

    public String toString() {
        return this.name;
    }

    public Environment primary() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (Environment)MethodLogger.aspectOf().wrapClass(new Application$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return Application.primary_aroundBody2(this, joinPoint);
    }

    public boolean hasPrimary() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodLogger.aspectOf().wrapClass(new Application$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return Application.hasPrimary_aroundBody4(this, joinPoint);
    }

    public void swap(@NotNull Environment candidate) {
        Environment environment = candidate;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)environment);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, environment, joinPoint};
            MethodLogger.aspectOf().wrapClass(new Application$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        Application.swap_aroundBody6(this, environment, joinPoint);
    }

    public Environment candidate(@NotNull Version version, @NotNull String template) {
        Version version2 = version;
        String string = template;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)version2, (Object)string);
        MethodValidator.aspectOf().beforeMethod(joinPoint);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, version2, string, joinPoint};
            return (Environment)MethodLogger.aspectOf().wrapClass(new Application$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return Application.candidate_aroundBody8(this, version2, string, joinPoint);
    }

    private Collection<Environment> environments() {
        DescribeEnvironmentsResult res = this.client.describeEnvironments(new DescribeEnvironmentsRequest().withApplicationName(this.name));
        LinkedList<Environment> envs = new LinkedList<Environment>();
        for (EnvironmentDescription desc : res.getEnvironments()) {
            envs.add(new Environment(this.client, desc.getEnvironmentId()));
        }
        return envs;
    }

    private CreateEnvironmentRequest suggest() {
        String ename;
        CreateEnvironmentRequest request = new CreateEnvironmentRequest();
        while (true) {
            if (!this.occupied(this.name)) {
                request.withCNAMEPrefix(this.name);
                break;
            }
            if (this.hasPrimary()) {
                request.withCNAMEPrefix(this.makeup());
                break;
            }
            Logger.info((Object)this, (String)"Waiting for '%s' CNAME", (Object[])new Object[]{this.name});
        }
        while (this.exists(ename = this.random())) {
        }
        request.withEnvironmentName(ename).withDescription(ename);
        Logger.info((Object)this, (String)"Using '%s' as env name", (Object[])new Object[]{ename});
        return request;
    }

    private String makeup() {
        String cname;
        do {
            cname = this.random();
            Logger.info((Object)this, (String)"Trying '%s' CNAME", (Object[])new Object[]{cname});
        } while (this.occupied(cname));
        return cname;
    }

    private boolean occupied(String cname) {
        return this.client.checkDNSAvailability(new CheckDNSAvailabilityRequest(cname)).getAvailable() == false;
    }

    private boolean exists(String ename) {
        boolean exists = false;
        for (Environment env : this.environments()) {
            if (!env.name().equals(ename)) continue;
            exists = true;
            break;
        }
        return exists;
    }

    private String random() {
        return String.format("%s-e%03d", this.name, 100 + new Random().nextInt(900));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Application)) {
            return false;
        }
        Application other = (Application)o;
        AWSElasticBeanstalk this$client = this.client;
        AWSElasticBeanstalk other$client = other.client;
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AWSElasticBeanstalk $client = this.client;
        result = result * 59 + ($client == null ? 0 : $client.hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        return result;
    }

    static {
        Application.ajc$preClinit();
    }

    static /* synthetic */ void clean_aroundBody0(Application ajc$this, boolean wipe, JoinPoint joinPoint) {
        for (Environment env : ajc$this.environments()) {
            if (env.primary() && env.green() && !wipe) {
                Logger.info((Object)ajc$this, (String)"Environment '%s' is primary and green", (Object[])new Object[]{env});
                continue;
            }
            if (env.terminated()) continue;
            if (wipe) {
                Logger.info((Object)ajc$this, (String)"Wiping out environment '%s' as required by configuration...", (Object[])new Object[]{env});
            } else {
                Logger.info((Object)ajc$this, (String)"Environment '%s' is not primary+green, terminating...", (Object[])new Object[]{env});
            }
            env.terminate();
        }
    }

    static /* synthetic */ Environment primary_aroundBody2(Application ajc$this, JoinPoint joinPoint) {
        Environment primary = null;
        for (Environment env : ajc$this.environments()) {
            if (!env.primary()) continue;
            primary = env;
            break;
        }
        if (primary == null) {
            throw new DeploymentException(String.format("Application '%s' doesn't have a primary env", ajc$this.name));
        }
        return primary;
    }

    static /* synthetic */ boolean hasPrimary_aroundBody4(Application ajc$this, JoinPoint joinPoint) {
        boolean has = false;
        for (Environment env : ajc$this.environments()) {
            if (!env.primary() || !env.green()) continue;
            has = true;
            break;
        }
        return has;
    }

    static /* synthetic */ void swap_aroundBody6(Application ajc$this, Environment candidate, JoinPoint joinPoint) {
        Environment primary = ajc$this.primary();
        ajc$this.client.swapEnvironmentCNAMEs(new SwapEnvironmentCNAMEsRequest().withDestinationEnvironmentName(primary.name()).withSourceEnvironmentName(candidate.name()));
        Logger.info((Object)ajc$this, (String)"Environment '%s' swapped CNAME with '%s'", (Object[])new Object[]{candidate.name(), primary.name()});
        if (candidate.stable() && !candidate.primary()) {
            throw new DeploymentException(String.format("Failed to swap, '%s' didn't become a primary env", candidate));
        }
        if (primary.stable() && primary.primary()) {
            throw new DeploymentException(String.format("Failed to swap, '%s' is still a primary env", primary));
        }
        primary.terminate();
    }

    static /* synthetic */ Environment candidate_aroundBody8(Application ajc$this, Version version, String template, JoinPoint joinPoint) {
        CreateEnvironmentRequest request = ajc$this.suggest();
        Logger.info((Object)ajc$this, (String)"Suggested candidate environment name is '%s' with '%s' CNAME", (Object[])new Object[]{request.getEnvironmentName(), request.getCNAMEPrefix()});
        CreateEnvironmentResult res = ajc$this.client.createEnvironment(request.withApplicationName(ajc$this.name).withVersionLabel(version.label()).withTemplateName(template));
        Logger.info((Object)ajc$this, (String)"Candidate environment '%s/%s/%s' created at CNAME '%s' (status:%s, health:%s)", (Object[])new Object[]{res.getApplicationName(), res.getEnvironmentName(), res.getEnvironmentId(), res.getCNAME(), res.getStatus(), res.getHealth()});
        return new Environment(ajc$this.client, res.getEnvironmentId());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Application.java", Application.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "clean", "com.jcabi.beanstalk.maven.plugin.Application", "boolean", "wipe", "", "void"), 93);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "primary", "com.jcabi.beanstalk.maven.plugin.Application", "", "", "", "com.jcabi.beanstalk.maven.plugin.Environment"), 136);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "hasPrimary", "com.jcabi.beanstalk.maven.plugin.Application", "", "", "", "boolean"), 159);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "swap", "com.jcabi.beanstalk.maven.plugin.Application", "com.jcabi.beanstalk.maven.plugin.Environment", "candidate", "", "void"), 174);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "candidate", "com.jcabi.beanstalk.maven.plugin.Application", "com.jcabi.beanstalk.maven.plugin.Version:java.lang.String", "version:template", "", "com.jcabi.beanstalk.maven.plugin.Environment"), 212);
        ajc$tjp_5 = factory.makeSJP("preinitialization", (Signature)factory.makeConstructorSig("4", "com.jcabi.beanstalk.maven.plugin.Application", "com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk:java.lang.String", "clnt:app", ""), 78);
    }
}

