/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.beanstalk.maven.plugin;

import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationSettingsDescription;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeConfigurationSettingsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEventsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentInfoDescription;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentInfoType;
import com.amazonaws.services.elasticbeanstalk.model.EventDescription;
import com.amazonaws.services.elasticbeanstalk.model.RequestEnvironmentInfoRequest;
import com.amazonaws.services.elasticbeanstalk.model.RetrieveEnvironmentInfoRequest;
import com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.TerminateEnvironmentResult;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentResult;
import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.MethodLogger;
import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.beanstalk.maven.plugin.DeploymentException;
import com.jcabi.beanstalk.maven.plugin.Environment$AjcClosure1;
import com.jcabi.beanstalk.maven.plugin.Environment$AjcClosure11;
import com.jcabi.beanstalk.maven.plugin.Environment$AjcClosure13;
import com.jcabi.beanstalk.maven.plugin.Environment$AjcClosure15;
import com.jcabi.beanstalk.maven.plugin.Environment$AjcClosure17;
import com.jcabi.beanstalk.maven.plugin.Environment$AjcClosure3;
import com.jcabi.beanstalk.maven.plugin.Environment$AjcClosure5;
import com.jcabi.beanstalk.maven.plugin.Environment$AjcClosure7;
import com.jcabi.beanstalk.maven.plugin.Environment$AjcClosure9;
import com.jcabi.beanstalk.maven.plugin.Version;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.commons.io.IOUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

@Loggable(value=1)
final class Environment {
    private static final long DELAY_MS;
    private final transient AWSElasticBeanstalk client;
    private final transient String eid;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;

    protected Environment(@NotNull AWSElasticBeanstalk clnt, @NotNull String idnt) {
        AWSElasticBeanstalk aWSElasticBeanstalk = clnt;
        String string = idnt;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)aWSElasticBeanstalk, (Object)string);
        MethodValidator.aspectOf().beforeCtor(joinPoint);
        this.client = clnt;
        this.eid = idnt;
        EnvironmentDescription desc = this.description();
        String template = desc.getTemplateName();
        if (template != null) {
            DescribeConfigurationSettingsResult res = this.client.describeConfigurationSettings(new DescribeConfigurationSettingsRequest().withApplicationName(desc.getApplicationName()).withTemplateName(template));
            for (ConfigurationSettingsDescription config : res.getConfigurationSettings()) {
                Logger.debug(Environment.class, (String)"Environment '%s/%s/%s' settings:", (Object[])new Object[]{config.getApplicationName(), config.getEnvironmentName()});
                for (ConfigurationOptionSetting opt : config.getOptionSettings()) {
                    Logger.debug(Environment.class, (String)"  %s/%s: %s", (Object[])new Object[]{opt.getNamespace(), opt.getOptionName(), opt.getValue()});
                }
            }
        }
    }

    public String toString() {
        EnvironmentDescription desc = this.description();
        return String.format("%s/%s/%s", desc.getEnvironmentName(), desc.getEnvironmentId(), desc.getCNAME());
    }

    public boolean primary() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodLogger.aspectOf().wrapClass(new Environment$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return Environment.primary_aroundBody0(this, joinPoint);
    }

    public String name() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodLogger.aspectOf().wrapClass(new Environment$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return Environment.name_aroundBody2(this, joinPoint);
    }

    public boolean green() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodLogger.aspectOf().wrapClass(new Environment$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return Environment.green_aroundBody4(this, joinPoint);
    }

    public boolean stable() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodLogger.aspectOf().wrapClass(new Environment$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return this.until(new Barrier(){

            @Override
            public String message() {
                return "stable state";
            }

            @Override
            public boolean allow(EnvironmentDescription desc) {
                return !desc.getStatus().matches(".*ing$");
            }
        });
    }

    public boolean terminated() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodLogger.aspectOf().wrapClass(new Environment$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return Environment.terminated_aroundBody8(this, joinPoint);
    }

    public void terminate() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodLogger.aspectOf().wrapClass(new Environment$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        Environment.terminate_aroundBody10(this, joinPoint);
    }

    public String[] events() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String[])MethodLogger.aspectOf().wrapClass(new Environment$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return Environment.events_aroundBody12(this, joinPoint);
    }

    public String tail() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodLogger.aspectOf().wrapClass(new Environment$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return Environment.tail_aroundBody14(this, joinPoint);
    }

    public void update(Version version) {
        Version version2 = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)version2);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, version2, joinPoint};
            MethodLogger.aspectOf().wrapClass(new Environment$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        Environment.update_aroundBody16(this, version2, joinPoint);
    }

    private EnvironmentDescription description() {
        DescribeEnvironmentsResult res = this.client.describeEnvironments(new DescribeEnvironmentsRequest().withEnvironmentIds(new String[]{this.eid}));
        if (res.getEnvironments().isEmpty()) {
            throw new DeploymentException(String.format("environment '%s' not found", this.eid));
        }
        EnvironmentDescription desc = (EnvironmentDescription)res.getEnvironments().get(0);
        Logger.debug((Object)this, (String)"ID=%s, env=%s, app=%s, CNAME=%s, label=%s, template=%s, status=%s, health=%s", (Object[])new Object[]{desc.getEnvironmentId(), desc.getEnvironmentName(), desc.getApplicationName(), desc.getCNAME(), desc.getVersionLabel(), desc.getTemplateName(), desc.getStatus(), desc.getHealth()});
        return desc;
    }

    private boolean until(Barrier barrier) {
        boolean passed = false;
        long start = System.currentTimeMillis();
        while (true) {
            EnvironmentDescription desc;
            if (barrier.allow(desc = this.description())) {
                passed = true;
                Logger.info((Object)this, (String)"Environment '%s/%s/%s': health=%s, status=%s", (Object[])new Object[]{desc.getApplicationName(), desc.getEnvironmentName(), desc.getEnvironmentId(), desc.getHealth(), desc.getStatus()});
                break;
            }
            Logger.info((Object)this, (String)"Environment '%s/%s/%s': health=%s, status=%s (waiting for %s, %[ms]s)", (Object[])new Object[]{desc.getApplicationName(), desc.getEnvironmentName(), desc.getEnvironmentId(), desc.getHealth(), desc.getStatus(), barrier.message(), System.currentTimeMillis() - start});
            if (System.currentTimeMillis() - start > DELAY_MS) {
                Logger.warn((Object)this, (String)"Environment failed to reach '%s' after %[ms]s", (Object[])new Object[]{barrier.message(), System.currentTimeMillis() - start});
                break;
            }
            try {
                TimeUnit.MINUTES.sleep(1L);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new DeploymentException(ex);
            }
        }
        return passed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Environment)) {
            return false;
        }
        Environment other = (Environment)o;
        AWSElasticBeanstalk this$client = this.client;
        AWSElasticBeanstalk other$client = other.client;
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$eid = this.eid;
        String other$eid = other.eid;
        return !(this$eid == null ? other$eid != null : !this$eid.equals(other$eid));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AWSElasticBeanstalk $client = this.client;
        result = result * 59 + ($client == null ? 0 : $client.hashCode());
        String $eid = this.eid;
        result = result * 59 + ($eid == null ? 0 : $eid.hashCode());
        return result;
    }

    static {
        Environment.ajc$preClinit();
        DELAY_MS = TimeUnit.MINUTES.toMillis(30L);
    }

    static /* synthetic */ boolean primary_aroundBody0(Environment ajc$this, JoinPoint joinPoint) {
        boolean primary;
        EnvironmentDescription desc = ajc$this.description();
        String prefix = String.format("%s.", desc.getApplicationName());
        boolean bl = primary = ajc$this.stable() && desc.getCNAME().startsWith(prefix);
        if (primary) {
            Logger.info((Object)ajc$this, (String)"Environment '%s' considered primary", (Object[])new Object[]{ajc$this});
        } else {
            Logger.info((Object)ajc$this, (String)"Environment '%s' considered secondary since its CNAME doesn't start with '%s'", (Object[])new Object[]{ajc$this, prefix});
        }
        return primary;
    }

    static /* synthetic */ String name_aroundBody2(Environment ajc$this, JoinPoint joinPoint) {
        return ajc$this.description().getEnvironmentName();
    }

    static /* synthetic */ boolean green_aroundBody4(Environment ajc$this, JoinPoint joinPoint) {
        return ajc$this.stable() && "Green".equals(ajc$this.description().getHealth());
    }

    static /* synthetic */ boolean terminated_aroundBody8(Environment ajc$this, JoinPoint joinPoint) {
        return ajc$this.stable() && "Terminated".equals(ajc$this.description().getStatus());
    }

    static /* synthetic */ void terminate_aroundBody10(Environment ajc$this, JoinPoint joinPoint) {
        if (!ajc$this.stable()) {
            throw new DeploymentException(String.format("env '%s' is not stable, can't terminate", ajc$this.eid));
        }
        if (!ajc$this.terminated()) {
            TerminateEnvironmentResult res = ajc$this.client.terminateEnvironment(new TerminateEnvironmentRequest().withEnvironmentId(ajc$this.eid).withTerminateResources(Boolean.valueOf(true)));
            Logger.info((Object)ajc$this, (String)"Environment '%s/%s/%s' is terminated (label:'%s', status:%s)", (Object[])new Object[]{res.getApplicationName(), res.getEnvironmentName(), res.getEnvironmentId(), res.getVersionLabel(), res.getStatus()});
        }
    }

    static /* synthetic */ String[] events_aroundBody12(Environment ajc$this, JoinPoint joinPoint) {
        if (!ajc$this.stable()) {
            throw new DeploymentException(String.format("env '%s' is not stable, can't get list of events", ajc$this.eid));
        }
        DescribeEventsResult res = ajc$this.client.describeEvents(new DescribeEventsRequest().withEnvironmentId(ajc$this.eid));
        LinkedList<String> events = new LinkedList<String>();
        for (EventDescription desc : res.getEvents()) {
            events.add(String.format("[%s]: %s", desc.getSeverity(), desc.getMessage()));
        }
        return events.toArray(new String[events.size()]);
    }

    static /* synthetic */ String tail_aroundBody14(Environment ajc$this, JoinPoint joinPoint) {
        List infos;
        if (!ajc$this.stable()) {
            throw new DeploymentException(String.format("env '%s' is not stable, can't get TAIL report", ajc$this.eid));
        }
        if (ajc$this.terminated()) {
            throw new DeploymentException(String.format("env '%s' is terminated, can't get TAIL report", ajc$this.eid));
        }
        ajc$this.client.requestEnvironmentInfo(new RequestEnvironmentInfoRequest().withEnvironmentId(ajc$this.eid).withInfoType(EnvironmentInfoType.Tail));
        RetrieveEnvironmentInfoRequest req = new RetrieveEnvironmentInfoRequest().withEnvironmentId(ajc$this.eid).withInfoType(EnvironmentInfoType.Tail);
        long start = System.currentTimeMillis();
        do {
            if (System.currentTimeMillis() - start > DELAY_MS) {
                throw new DeploymentException(String.format("env '%s' doesn't report its TAIL, time out", ajc$this.eid));
            }
            Logger.info((Object)ajc$this, (String)"Waiting for TAIL report of %s", (Object[])new Object[]{ajc$this.eid});
        } while ((infos = ajc$this.client.retrieveEnvironmentInfo(req).getEnvironmentInfo()).isEmpty());
        EnvironmentInfoDescription desc = (EnvironmentInfoDescription)infos.get(0);
        try {
            return IOUtils.toString((InputStream)new URL(desc.getMessage()).openStream());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    static /* synthetic */ void update_aroundBody16(Environment ajc$this, Version version, JoinPoint joinPoint) {
        UpdateEnvironmentResult res = ajc$this.client.updateEnvironment(new UpdateEnvironmentRequest().withEnvironmentId(ajc$this.eid).withVersionLabel(version.label()));
        Logger.info((Object)ajc$this, (String)"Environment '%s' updated to '%s'", (Object[])new Object[]{res.getEnvironmentId(), res.getVersionLabel()});
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Environment.java", Environment.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "primary", "com.jcabi.beanstalk.maven.plugin.Environment", "", "", "", "boolean"), 146);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "name", "com.jcabi.beanstalk.maven.plugin.Environment", "", "", "", "java.lang.String"), 171);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "green", "com.jcabi.beanstalk.maven.plugin.Environment", "", "", "", "boolean"), 179);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stable", "com.jcabi.beanstalk.maven.plugin.Environment", "", "", "", "boolean"), 187);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "terminated", "com.jcabi.beanstalk.maven.plugin.Environment", "", "", "", "boolean"), 206);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "terminate", "com.jcabi.beanstalk.maven.plugin.Environment", "", "", "", "void"), 214);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "events", "com.jcabi.beanstalk.maven.plugin.Environment", "", "", "", "[Ljava.lang.String;"), 244);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "tail", "com.jcabi.beanstalk.maven.plugin.Environment", "", "", "", "java.lang.String"), 269);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "update", "com.jcabi.beanstalk.maven.plugin.Environment", "com.jcabi.beanstalk.maven.plugin.Version", "version", "", "void"), 327);
        ajc$tjp_9 = factory.makeSJP("preinitialization", (Signature)factory.makeConstructorSig("4", "com.jcabi.beanstalk.maven.plugin.Environment", "com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk:java.lang.String", "clnt:idnt", ""), 98);
    }

    private static interface Barrier {
        public boolean allow(EnvironmentDescription var1);

        public String message();
    }
}

