/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.beanstalk.maven.plugin;

import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.jcabi.aspects.Cacheable;
import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.MethodCacher;
import com.jcabi.aspects.aj.MethodLogger;
import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.beanstalk.maven.plugin.Bundle;
import com.jcabi.beanstalk.maven.plugin.DeploymentException;
import com.jcabi.beanstalk.maven.plugin.OverridingBundle$AjcClosure1;
import com.jcabi.beanstalk.maven.plugin.OverridingBundle$AjcClosure3;
import com.jcabi.beanstalk.maven.plugin.OverridingBundle$AjcClosure5;
import com.jcabi.beanstalk.maven.plugin.OverridingBundle$AjcClosure7;
import com.jcabi.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.validation.constraints.NotNull;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Loggable(value=1)
final class OverridingBundle
implements Bundle {
    private final transient AmazonS3 client;
    private final transient String bucket;
    private final transient String key;
    private final transient File war;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    protected OverridingBundle(@NotNull AmazonS3 clnt, @NotNull String bckt, @NotNull String label, @NotNull File file) {
        AmazonS3 amazonS3 = clnt;
        String string = bckt;
        String string2 = label;
        File file2 = file;
        Object[] objectArray = new Object[]{amazonS3, string, string2, file2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object[])objectArray);
        MethodValidator.aspectOf().beforeCtor(joinPoint);
        this.client = clnt;
        this.bucket = bckt;
        this.key = label;
        this.war = file;
        if (!this.war.exists()) {
            throw new DeploymentException(String.format("WAR file %s doesn't exist", this.war));
        }
    }

    @Override
    @Cacheable
    public S3Location location() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (S3Location)MethodCacher.aspectOf().cache(new OverridingBundle$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @Override
    public String name() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodLogger.aspectOf().wrapClass(new OverridingBundle$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return this.key;
    }

    @Override
    public String etag() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodLogger.aspectOf().wrapClass(new OverridingBundle$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OverridingBundle.etag_aroundBody6(this, joinPoint);
    }

    private boolean exists() {
        boolean exists = false;
        if (this.keyExists()) {
            ObjectMetadata meta = this.client.getObjectMetadata(this.bucket, this.key);
            String etag = this.etag();
            if (meta.getETag().equals(etag)) {
                Logger.info((Object)this, (String)"MD5 ETag '%s' of existing S3 object '%s' (%s) equals to the one of the local file (%s)", (Object[])new Object[]{meta.getETag(), this.key, FileUtils.byteCountToDisplaySize((long)meta.getContentLength()), FileUtils.byteCountToDisplaySize((long)this.war.length())});
                exists = true;
            } else {
                Logger.info((Object)this, (String)"MD5 ETag '%s' of S3 object '%s' (%s) differs from '%s' of the local file (%s)", (Object[])new Object[]{meta.getETag(), this.key, FileUtils.byteCountToDisplaySize((long)meta.getContentLength()), etag, FileUtils.byteCountToDisplaySize((long)this.war.length())});
            }
        }
        return exists;
    }

    private boolean keyExists() {
        ObjectListing listing = this.client.listObjects(new ListObjectsRequest().withBucketName(this.bucket).withDelimiter("").withMaxKeys(Integer.valueOf(1)).withPrefix(this.key));
        List summaries = listing.getObjectSummaries();
        boolean exists = false;
        if (summaries.isEmpty()) {
            Logger.info((Object)this, (String)"S3 object '%s' not found in '%s' bucket", (Object[])new Object[]{this.key, this.bucket});
        } else {
            S3ObjectSummary summary = (S3ObjectSummary)summaries.get(0);
            Logger.info((Object)this, (String)"S3 object '%s' found in '%s' bucket (size=%d, last-modified=%s, etag=%s)", (Object[])new Object[]{summary.getKey(), summary.getBucketName(), summary.getSize(), summary.getLastModified(), summary.getETag()});
            exists = true;
        }
        return exists;
    }

    public String toString() {
        return "OverridingBundle(client=" + this.client + ", bucket=" + this.bucket + ", key=" + this.key + ", war=" + this.war + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OverridingBundle)) {
            return false;
        }
        OverridingBundle other = (OverridingBundle)o;
        AmazonS3 this$client = this.client;
        AmazonS3 other$client = other.client;
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$bucket = this.bucket;
        String other$bucket = other.bucket;
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        File this$war = this.war;
        File other$war = other.war;
        return !(this$war == null ? other$war != null : !((Object)this$war).equals(other$war));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AmazonS3 $client = this.client;
        result = result * 59 + ($client == null ? 0 : $client.hashCode());
        String $bucket = this.bucket;
        result = result * 59 + ($bucket == null ? 0 : $bucket.hashCode());
        String $key = this.key;
        result = result * 59 + ($key == null ? 0 : $key.hashCode());
        File $war = this.war;
        result = result * 59 + ($war == null ? 0 : ((Object)$war).hashCode());
        return result;
    }

    static {
        OverridingBundle.ajc$preClinit();
    }

    static /* synthetic */ S3Location location_aroundBody0(OverridingBundle ajc$this, JoinPoint joinPoint) {
        if (ajc$this.exists()) {
            Logger.info((Object)ajc$this, (String)"No need to upload %s (%s) to S3, will use existing object", (Object[])new Object[]{ajc$this.war, FileUtils.byteCountToDisplaySize((long)ajc$this.war.length())});
        } else {
            Logger.info((Object)ajc$this, (String)"Uploading %s (%s) to s3://%s/%s... (may take a few minutes)", (Object[])new Object[]{ajc$this.war, FileUtils.byteCountToDisplaySize((long)ajc$this.war.length()), ajc$this.bucket, ajc$this.key});
            PutObjectResult res = ajc$this.client.putObject(ajc$this.bucket, ajc$this.key, ajc$this.war);
            Logger.info((Object)ajc$this, (String)"Uploaded successfully to S3, etag=%s, expires=%s, exp.rule=%s, encryption=%s, version=%s", (Object[])new Object[]{res.getETag(), res.getExpirationTime(), res.getExpirationTimeRuleId(), res.getServerSideEncryption(), res.getVersionId()});
        }
        return new S3Location(ajc$this.bucket, ajc$this.key);
    }

    static /* synthetic */ S3Location location_aroundBody2(OverridingBundle overridingBundle, JoinPoint joinPoint) {
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{overridingBundle, joinPoint};
            return (S3Location)MethodLogger.aspectOf().wrapClass(new OverridingBundle$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OverridingBundle.location_aroundBody0(overridingBundle, joinPoint);
    }

    static /* synthetic */ String etag_aroundBody6(OverridingBundle ajc$this, JoinPoint joinPoint) {
        try {
            FileInputStream stream = new FileInputStream(ajc$this.war);
            String hash = DigestUtils.md5Hex((InputStream)stream);
            IOUtils.closeQuietly((InputStream)stream);
            return hash;
        }
        catch (IOException ex) {
            throw new DeploymentException(ex);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OverridingBundle.java", OverridingBundle.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "location", "com.jcabi.beanstalk.maven.plugin.OverridingBundle", "", "", "", "com.amazonaws.services.elasticbeanstalk.model.S3Location"), 110);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "name", "com.jcabi.beanstalk.maven.plugin.OverridingBundle", "", "", "", "java.lang.String"), 145);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "etag", "com.jcabi.beanstalk.maven.plugin.OverridingBundle", "", "", "", "java.lang.String"), 154);
        ajc$tjp_3 = factory.makeSJP("preinitialization", (Signature)factory.makeConstructorSig("4", "com.jcabi.beanstalk.maven.plugin.OverridingBundle", "com.amazonaws.services.s3.AmazonS3:java.lang.String:java.lang.String:java.io.File", "clnt:bckt:label:file", ""), 95);
    }
}

