/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.beanstalk.maven.plugin;

import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationVersionDescription;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionResult;
import com.amazonaws.services.elasticbeanstalk.model.DeleteApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationVersionsResult;
import com.jcabi.aspects.Loggable;
import com.jcabi.aspects.aj.MethodLogger;
import com.jcabi.aspects.aj.MethodValidator;
import com.jcabi.beanstalk.maven.plugin.Bundle;
import com.jcabi.beanstalk.maven.plugin.DeploymentException;
import com.jcabi.beanstalk.maven.plugin.OverridingVersion$AjcClosure1;
import com.jcabi.beanstalk.maven.plugin.Version;
import com.jcabi.log.Logger;
import javax.validation.constraints.NotNull;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Loggable(value=1)
final class OverridingVersion
implements Version {
    private final transient AWSElasticBeanstalk client;
    private final transient String application;
    private final transient Bundle bundle;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    protected OverridingVersion(@NotNull AWSElasticBeanstalk clnt, @NotNull String app, @NotNull Bundle bndl) {
        AWSElasticBeanstalk aWSElasticBeanstalk = clnt;
        String string = app;
        Bundle bundle = bndl;
        Object[] objectArray = new Object[]{aWSElasticBeanstalk, string, bundle};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object[])objectArray);
        MethodValidator.aspectOf().beforeCtor(joinPoint);
        this.client = clnt;
        this.application = app;
        this.bundle = bndl;
    }

    public String toString() {
        return this.bundle.name();
    }

    @Override
    public String label() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (!MethodLogger.ajc$cflowCounter$0.isValid()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodLogger.aspectOf().wrapClass(new OverridingVersion$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
        }
        return OverridingVersion.label_aroundBody0(this, joinPoint);
    }

    private boolean exists() {
        DescribeApplicationVersionsResult res = this.client.describeApplicationVersions(new DescribeApplicationVersionsRequest().withApplicationName(this.application).withVersionLabels(new String[]{this.bundle.name()}));
        boolean exists = false;
        if (res.getApplicationVersions().isEmpty()) {
            Logger.info((Object)this, (String)"Version '%s' is absent in '%s'", (Object[])new Object[]{this.bundle.name(), this.application});
        } else {
            ApplicationVersionDescription ver = (ApplicationVersionDescription)res.getApplicationVersions().get(0);
            if (ver.getSourceBundle().equals((Object)this.bundle.location()) && ver.getDescription().equals(this.bundle.etag())) {
                Logger.info((Object)this, (String)"Version '%s' already exists for '%s', etag='%s'", (Object[])new Object[]{ver.getVersionLabel(), ver.getApplicationName(), ver.getDescription()});
                exists = true;
            } else {
                this.client.deleteApplicationVersion(new DeleteApplicationVersionRequest().withApplicationName(this.application).withVersionLabel(this.bundle.name()));
                Logger.info((Object)this, (String)"Version '%s' deleted in '%s' because of its outdated S3 location", (Object[])new Object[]{this.bundle.name(), this.application});
            }
        }
        return exists;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OverridingVersion)) {
            return false;
        }
        OverridingVersion other = (OverridingVersion)o;
        AWSElasticBeanstalk this$client = this.client;
        AWSElasticBeanstalk other$client = other.client;
        if (this$client == null ? other$client != null : !this$client.equals(other$client)) {
            return false;
        }
        String this$application = this.application;
        String other$application = other.application;
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
            return false;
        }
        Bundle this$bundle = this.bundle;
        Bundle other$bundle = other.bundle;
        return !(this$bundle == null ? other$bundle != null : !this$bundle.equals(other$bundle));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AWSElasticBeanstalk $client = this.client;
        result = result * 59 + ($client == null ? 0 : $client.hashCode());
        String $application = this.application;
        result = result * 59 + ($application == null ? 0 : $application.hashCode());
        Bundle $bundle = this.bundle;
        result = result * 59 + ($bundle == null ? 0 : $bundle.hashCode());
        return result;
    }

    static {
        OverridingVersion.ajc$preClinit();
    }

    static /* synthetic */ String label_aroundBody0(OverridingVersion ajc$this, JoinPoint joinPoint) {
        if (ajc$this.exists()) {
            Logger.info((Object)ajc$this, (String)"Version '%s' already exists for '%s'", (Object[])new Object[]{ajc$this.bundle.name(), ajc$this.application});
        } else {
            CreateApplicationVersionResult res = ajc$this.client.createApplicationVersion(new CreateApplicationVersionRequest().withApplicationName(ajc$this.application).withVersionLabel(ajc$this.bundle.name()).withSourceBundle(ajc$this.bundle.location()).withDescription(ajc$this.bundle.etag()));
            ApplicationVersionDescription desc = res.getApplicationVersion();
            Logger.info((Object)ajc$this, (String)"Version '%s' created for '%s' (%s): '%s'", (Object[])new Object[]{desc.getVersionLabel(), desc.getApplicationName(), ajc$this.bundle.location(), desc.getDescription()});
            if (!desc.getVersionLabel().equals(ajc$this.bundle.name())) {
                throw new DeploymentException(String.format("version label is '%s' while '%s' expected", desc.getVersionLabel(), ajc$this.bundle.name()));
            }
        }
        return ajc$this.bundle.name();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OverridingVersion.java", OverridingVersion.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "label", "com.jcabi.beanstalk.maven.plugin.OverridingVersion", "", "", "", "java.lang.String"), 96);
        ajc$tjp_1 = factory.makeSJP("preinitialization", (Signature)factory.makeConstructorSig("4", "com.jcabi.beanstalk.maven.plugin.OverridingVersion", "com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk:java.lang.String:com.jcabi.beanstalk.maven.plugin.Bundle", "clnt:app:bndl", ""), 77);
    }
}

