/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.beanstalk.maven.plugin;

import com.google.common.base.Joiner;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.maven.plugin.MojoFailureException;

public final class WarFile {
    private final transient ZipFile war;

    public WarFile(ZipFile file) {
        this.war = file;
    }

    public void checkEbextensionsValidity() throws MojoFailureException {
        ZipEntry ebextdir = this.war.getEntry(".ebextensions");
        if (ebextdir == null) {
            throw new MojoFailureException(".ebextensions directory does not exist in the WAR file");
        }
        Enumeration<? extends ZipEntry> entries = this.war.entries();
        int files = 0;
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (!entry.getName().startsWith(".ebextensions/") || entry.isDirectory()) continue;
            ++files;
            String text = this.readFile(this.war, entry);
            if (this.validJson(text) || this.validYaml(text)) continue;
            throw new MojoFailureException(Joiner.on((String)"").join((Object)"File '", (Object)entry.getName(), new Object[]{"' in .ebextensions is neither valid JSON,", " nor valid YAML"}));
        }
        if (files < 1) {
            throw new MojoFailureException(".ebextensions contains no config files.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(ZipFile warfile, ZipEntry entry) {
        String text = null;
        InputStream inputStream = null;
        InputStreamReader reader = null;
        try {
            inputStream = warfile.getInputStream(entry);
            reader = new InputStreamReader(inputStream);
            text = CharStreams.toString((Readable)reader);
        }
        catch (IOException exception) {
            try {
                Logger.error((Object)this, (String)exception.getMessage());
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly((InputStream)inputStream);
                Closeables.closeQuietly(reader);
                throw throwable;
            }
            Closeables.closeQuietly((InputStream)inputStream);
            Closeables.closeQuietly((Reader)reader);
        }
        Closeables.closeQuietly((InputStream)inputStream);
        Closeables.closeQuietly((Reader)reader);
        return text;
    }

    private boolean validYaml(String text) {
        throw new NotImplementedException("com.jcabi.beanstalk.maven.plugin.AbstractBeanstalkMojo.validYaml");
    }

    private boolean validJson(String text) {
        throw new NotImplementedException("com.jcabi.beanstalk.maven.plugin.AbstractBeanstalkMojo.validJson");
    }
}

