/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.dynamodb.maven.plugin;

import com.jcabi.dynamodb.maven.plugin.AbstractDynamoMojo;
import java.io.File;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

abstract class AbstractEnviromentMojo
extends AbstractDynamoMojo {
    @Parameter(required=true)
    private transient File dist;
    @Parameter(required=false)
    private transient File home;

    AbstractEnviromentMojo() {
    }

    @Override
    public void environment() throws MojoFailureException {
        if (!this.dist.exists() || !this.dist.isDirectory()) {
            throw new MojoFailureException(String.format("DynamoDB Local distribution doesn't exist or is not a directory: %s", this.dist));
        }
        if (this.home == null) {
            this.home = new File(System.getProperty("java.home"));
        }
        if (!this.home.exists()) {
            throw new MojoFailureException(String.format("Java home doesn't exist: %s", this.home));
        }
    }

    protected File distdir() {
        return this.dist;
    }

    protected File homedir() {
        return this.home;
    }

    @Override
    public String toString() {
        return "AbstractEnviromentMojo(dist=" + this.dist + ", home=" + this.home + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractEnviromentMojo)) {
            return false;
        }
        AbstractEnviromentMojo other = (AbstractEnviromentMojo)((Object)o);
        return other.canEqual((Object)this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractEnviromentMojo;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

