/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.dynamodb.maven.plugin;

import com.jcabi.dynamodb.core.Instances;
import com.jcabi.dynamodb.core.Tables;
import com.jcabi.dynamodb.maven.plugin.AbstractDynamoMojo;
import java.io.IOException;
import java.util.Collection;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(threadSafe=true, name="create-tables", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public final class CreateTablesMojo
extends AbstractDynamoMojo {
    @Parameter(required=false)
    private transient Collection<String> tables;
    @Parameter(required=false, defaultValue="http://localhost")
    private transient String endpoint;
    @Parameter(required=false, defaultValue="AWS-Key")
    private transient String key;
    @Parameter(required=false, defaultValue="AWS-Secret")
    private transient String secret;

    @Override
    public void environment() {
    }

    @Override
    public void run(Instances instances) throws MojoFailureException {
        try {
            new Tables(this.tables, this.endpoint, this.tcpPort(), this.key, this.secret).create();
        }
        catch (IOException ex) {
            throw new MojoFailureException(String.format("Failed to create tables for instances: %s", instances), (Throwable)ex);
        }
    }

    @Override
    public String toString() {
        return "CreateTablesMojo(tables=" + this.tables + ", endpoint=" + this.endpoint + ", key=" + this.key + ", secret=" + this.secret + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateTablesMojo)) {
            return false;
        }
        CreateTablesMojo other = (CreateTablesMojo)((Object)o);
        return other.canEqual((Object)this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CreateTablesMojo;
    }

    @Override
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

