/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.dynamodb.maven.plugin;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.util.Tables;
import com.jcabi.dynamodb.maven.plugin.AbstractDynamoMojo;
import com.jcabi.dynamodb.maven.plugin.Instances;
import com.jcabi.log.Logger;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(threadSafe=true, name="create-tables", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public final class CreateTablesMojo
extends AbstractDynamoMojo {
    @Parameter(required=false)
    private transient Collection<String> tables;
    @Parameter(required=false, defaultValue="http://localhost")
    private transient String endpoint;
    @Parameter(required=false, defaultValue="AWS-Key")
    private transient String key;
    @Parameter(required=false, defaultValue="AWS-Secret")
    private transient String secret;

    @Override
    public void run(Instances instances) throws MojoFailureException {
        AmazonDynamoDBClient aws = new AmazonDynamoDBClient((AWSCredentials)new BasicAWSCredentials(this.key, this.secret));
        aws.setEndpoint(String.format("%s:%d", this.endpoint, this.tcpPort()));
        for (String table : this.tables) {
            JsonObject json = this.readJson(table);
            if (json.containsKey((Object)"TableName")) {
                String name = json.getString("TableName");
                if (Tables.doesTableExist((AmazonDynamoDB)aws, (String)name)) {
                    Logger.info((Object)((Object)this), (String)"Table '%s' already exists, skipping...", (Object[])new Object[]{name});
                    continue;
                }
                this.createTable((AmazonDynamoDB)aws, json);
                continue;
            }
            throw new MojoFailureException(String.format("File '%s' does not specify TableName attribute", table));
        }
    }

    private void createTable(AmazonDynamoDB aws, JsonObject json) {
        JsonArray array;
        LinkedList<Object> indexes;
        String name = json.getString("TableName");
        CreateTableRequest request = new CreateTableRequest().withTableName(name);
        if (json.containsKey((Object)"KeySchema")) {
            Collection<KeySchemaElement> keys = this.keySchema(json);
            request.setKeySchema(keys);
        }
        if (json.containsKey((Object)"AttributeDefinitions")) {
            LinkedList<AttributeDefinition> attrs = new LinkedList<AttributeDefinition>();
            JsonArray schema = json.getJsonArray("AttributeDefinitions");
            for (JsonObject defn : schema.getValuesAs(JsonObject.class)) {
                attrs.add(new AttributeDefinition(defn.getString("AttributeName"), defn.getString("AttributeType")));
            }
            request.setAttributeDefinitions(attrs);
        }
        if (json.containsKey((Object)"ProvisionedThroughput")) {
            JsonObject throughput = json.getJsonObject("ProvisionedThroughput");
            request.setProvisionedThroughput(new ProvisionedThroughput(Long.valueOf(Long.parseLong(throughput.getString("ReadCapacityUnits"))), Long.valueOf(Long.parseLong(throughput.getString("WriteCapacityUnits")))));
        }
        if (json.containsKey((Object)"GlobalSecondaryIndexes")) {
            indexes = new LinkedList<Object>();
            array = json.getJsonArray("GlobalSecondaryIndexes");
            for (JsonObject index : array.getValuesAs(JsonObject.class)) {
                JsonObject throughput = index.getJsonObject("ProvisionedThroughput");
                GlobalSecondaryIndex gsi = new GlobalSecondaryIndex().withIndexName(index.getString("IndexName")).withKeySchema(this.keySchema(index)).withProjection(this.projection(index)).withProvisionedThroughput(new ProvisionedThroughput(Long.valueOf(Long.parseLong(throughput.getString("ReadCapacityUnits"))), Long.valueOf(Long.parseLong(throughput.getString("WriteCapacityUnits")))));
                indexes.add(gsi);
            }
            request.setGlobalSecondaryIndexes(indexes);
        }
        if (json.containsKey((Object)"LocalSecondaryIndexes")) {
            indexes = new LinkedList();
            array = json.getJsonArray("LocalSecondaryIndexes");
            for (JsonObject index : array.getValuesAs(JsonObject.class)) {
                LocalSecondaryIndex lsi = new LocalSecondaryIndex().withIndexName(index.getString("IndexName")).withKeySchema(this.keySchema(index)).withProjection(this.projection(index));
                indexes.add(lsi);
            }
            request.setLocalSecondaryIndexes(indexes);
        }
        aws.createTable(request);
        Logger.info((Object)((Object)this), (String)"Waiting for table '%s' to become active", (Object[])new Object[]{name});
        Tables.waitForTableToBecomeActive((AmazonDynamoDB)aws, (String)name);
        Logger.info((Object)((Object)this), (String)"Table '%s' is now ready for use", (Object[])new Object[]{name});
    }

    private Projection projection(JsonObject json) {
        JsonObject projn = json.getJsonObject("Projection");
        Projection projection = new Projection().withProjectionType(projn.getString("ProjectionType"));
        LinkedList<String> nonkeyattrs = new LinkedList<String>();
        if (projn.containsKey((Object)"NonKeyAttributes")) {
            for (JsonValue nonkey : projn.getJsonArray("NonKeyAttributes")) {
                nonkeyattrs.add(nonkey.toString());
            }
            projection.setNonKeyAttributes(nonkeyattrs);
        }
        return projection;
    }

    private Collection<KeySchemaElement> keySchema(JsonObject json) {
        LinkedList<KeySchemaElement> keys = new LinkedList<KeySchemaElement>();
        JsonArray schema = json.getJsonArray("KeySchema");
        for (JsonValue value : schema) {
            JsonObject element = (JsonObject)value;
            keys.add(new KeySchemaElement(element.getString("AttributeName"), element.getString("KeyType")));
        }
        return keys;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject readJson(String file) throws MojoFailureException {
        FileInputStream stream = null;
        JsonObject json = null;
        try {
            stream = new FileInputStream(file);
            json = Json.createReader((InputStream)stream).readObject();
            if (stream == null) return json;
        }
        catch (IOException ex) {
            try {
                throw new MojoFailureException("Failed to read table definition", (Throwable)ex);
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException ex2) {
                    Logger.error((Object)((Object)this), (String)"Failed to close stream with message %s", (Object[])new Object[]{ex2.getMessage()});
                }
                throw throwable;
            }
        }
        try {
            ((InputStream)stream).close();
            return json;
        }
        catch (IOException ex) {
            Logger.error((Object)((Object)this), (String)"Failed to close stream with message %s", (Object[])new Object[]{ex.getMessage()});
            return json;
        }
    }

    @Override
    public String toString() {
        return "CreateTablesMojo(tables=" + this.tables + ", endpoint=" + this.endpoint + ", key=" + this.key + ", secret=" + this.secret + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateTablesMojo)) {
            return false;
        }
        CreateTablesMojo other = (CreateTablesMojo)((Object)o);
        return other.canEqual((Object)this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CreateTablesMojo;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }
}

