/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.dynamodb.core;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.util.TableUtils;
import com.jcabi.log.Logger;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;

public final class Tables {
    private final transient Collection<String> locations;
    private final transient String endpoint;
    private final transient Integer port;
    private final transient String key;
    private final transient String secret;

    public Tables(Collection<String> locations, String endpoint, Integer port, String key, String secret) {
        this.locations = locations;
        this.endpoint = endpoint;
        this.port = port;
        this.key = key;
        this.secret = secret;
    }

    public void create() throws IOException {
        AmazonDynamoDBClient aws = new AmazonDynamoDBClient((AWSCredentials)new BasicAWSCredentials(this.key, this.secret));
        aws.setEndpoint(String.format("%s:%d", this.endpoint, this.port));
        for (String table : this.locations) {
            JsonObject json = this.readJson(table);
            if (json.containsKey((Object)"TableName")) {
                String name = json.getString("TableName");
                if (Tables.exists((AmazonDynamoDB)aws, name)) {
                    Logger.info((Object)this, (String)"Table '%s' already exists, skipping...", (Object[])new Object[]{name});
                    continue;
                }
                this.createTable((AmazonDynamoDB)aws, json);
                continue;
            }
            throw new IOException(String.format("File '%s' does not specify TableName attribute", table));
        }
    }

    private static boolean exists(AmazonDynamoDB aws, String name) {
        boolean exists;
        try {
            TableUtils.waitUntilExists((AmazonDynamoDB)aws, (String)name, (int)1000, (int)100);
            exists = true;
        }
        catch (AmazonClientException ex) {
            exists = false;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
        return exists;
    }

    private void createTable(AmazonDynamoDB aws, JsonObject json) {
        JsonArray array;
        LinkedList<Object> indexes;
        String name = json.getString("TableName");
        CreateTableRequest request = new CreateTableRequest().withTableName(name);
        if (json.containsKey((Object)"KeySchema")) {
            Collection<KeySchemaElement> keys = this.keySchema(json);
            request.setKeySchema(keys);
        }
        if (json.containsKey((Object)"AttributeDefinitions")) {
            LinkedList<AttributeDefinition> attrs = new LinkedList<AttributeDefinition>();
            JsonArray schema = json.getJsonArray("AttributeDefinitions");
            for (JsonObject defn : schema.getValuesAs(JsonObject.class)) {
                attrs.add(new AttributeDefinition(defn.getString("AttributeName"), defn.getString("AttributeType")));
            }
            request.setAttributeDefinitions(attrs);
        }
        if (json.containsKey((Object)"ProvisionedThroughput")) {
            JsonObject throughput = json.getJsonObject("ProvisionedThroughput");
            request.setProvisionedThroughput(new ProvisionedThroughput(Long.valueOf(this.asLong(throughput, "ReadCapacityUnits")), Long.valueOf(this.asLong(throughput, "WriteCapacityUnits"))));
        }
        if (json.containsKey((Object)"GlobalSecondaryIndexes")) {
            indexes = new LinkedList<Object>();
            array = json.getJsonArray("GlobalSecondaryIndexes");
            for (JsonObject index : array.getValuesAs(JsonObject.class)) {
                JsonObject throughput = index.getJsonObject("ProvisionedThroughput");
                GlobalSecondaryIndex gsi = new GlobalSecondaryIndex().withIndexName(index.getString("IndexName")).withKeySchema(this.keySchema(index)).withProjection(this.projection(index)).withProvisionedThroughput(new ProvisionedThroughput(Long.valueOf(this.asLong(throughput, "ReadCapacityUnits")), Long.valueOf(this.asLong(throughput, "WriteCapacityUnits"))));
                indexes.add(gsi);
            }
            request.setGlobalSecondaryIndexes(indexes);
        }
        if (json.containsKey((Object)"LocalSecondaryIndexes")) {
            indexes = new LinkedList();
            array = json.getJsonArray("LocalSecondaryIndexes");
            for (JsonObject index : array.getValuesAs(JsonObject.class)) {
                LocalSecondaryIndex lsi = new LocalSecondaryIndex().withIndexName(index.getString("IndexName")).withKeySchema(this.keySchema(index)).withProjection(this.projection(index));
                indexes.add(lsi);
            }
            request.setLocalSecondaryIndexes(indexes);
        }
        aws.createTable(request);
        Logger.info((Object)this, (String)"Waiting for table '%s' to become active", (Object[])new Object[]{name});
        try {
            TableUtils.waitUntilActive((AmazonDynamoDB)aws, (String)name);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(ex);
        }
        Logger.info((Object)this, (String)"Table '%s' is now ready for use", (Object[])new Object[]{name});
    }

    private long asLong(JsonObject json, String name) {
        long result;
        try {
            result = json.getJsonNumber(name).longValue();
        }
        catch (ClassCastException ex) {
            result = Long.parseLong(json.getString(name));
        }
        return result;
    }

    private Projection projection(JsonObject json) {
        JsonObject projn = json.getJsonObject("Projection");
        Projection projection = new Projection().withProjectionType(projn.getString("ProjectionType"));
        LinkedList<String> nonkeyattrs = new LinkedList<String>();
        if (projn.containsKey((Object)"NonKeyAttributes")) {
            for (JsonValue nonkey : projn.getJsonArray("NonKeyAttributes")) {
                nonkeyattrs.add(nonkey.toString());
            }
            projection.setNonKeyAttributes(nonkeyattrs);
        }
        return projection;
    }

    private Collection<KeySchemaElement> keySchema(JsonObject json) {
        LinkedList<KeySchemaElement> keys = new LinkedList<KeySchemaElement>();
        JsonArray schema = json.getJsonArray("KeySchema");
        for (JsonValue value : schema) {
            JsonObject element = (JsonObject)value;
            keys.add(new KeySchemaElement(element.getString("AttributeName"), element.getString("KeyType")));
        }
        return keys;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject readJson(String file) throws IOException {
        FileInputStream stream = null;
        JsonObject json = null;
        try {
            stream = new FileInputStream(file);
            json = Json.createReader((InputStream)stream).readObject();
            if (stream == null) return json;
        }
        catch (FileNotFoundException ex) {
            try {
                throw new IOException("Failed to read table definition", ex);
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException ex2) {
                    Logger.error((Object)this, (String)"Failed to close stream with message %s", (Object[])new Object[]{ex2.getMessage()});
                }
                throw throwable;
            }
        }
        try {
            ((InputStream)stream).close();
            return json;
        }
        catch (IOException ex) {
            Logger.error((Object)this, (String)"Failed to close stream with message %s", (Object[])new Object[]{ex.getMessage()});
            return json;
        }
    }
}

