/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.email;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.email.Enclosure;
import com.jcabi.email.Stamp;
import com.jcabi.immutable.Array;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

@Immutable
public interface Envelope {
    public static final Envelope EMPTY = new Envelope(){

        @Override
        public Message unwrap() {
            return new MimeMessage(Session.getDefaultInstance((Properties)new Properties()));
        }
    };

    public Message unwrap() throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Draft
    implements Envelope {
        private final transient Envelope env;

        public Draft(Envelope origin) {
            this.env = origin;
        }

        @Override
        public Message unwrap() throws IOException {
            Message msg = this.env.unwrap();
            try {
                msg.setFlag(Flags.Flag.DRAFT, true);
            }
            catch (MessagingException ex) {
                throw new IOException(ex);
            }
            return msg;
        }

        public String toString() {
            return "Envelope.Draft(env=" + this.env + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Draft)) {
                return false;
            }
            Draft other = (Draft)o;
            Envelope this$env = this.env;
            Envelope other$env = other.env;
            return !(this$env == null ? other$env != null : !this$env.equals(other$env));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Envelope $env = this.env;
            result = result * 59 + ($env == null ? 43 : $env.hashCode());
            return result;
        }
    }

    @Immutable
    @Loggable(value=1)
    public static final class Constant
    implements Envelope {
        private static final Cache<Envelope, Message> CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
        private final transient Envelope origin;

        public Constant(Envelope env) {
            this.origin = env;
        }

        @Override
        public Message unwrap() throws IOException {
            try {
                return (Message)CACHE.get((Object)this.origin, (Callable)new Callable<Message>(){

                    @Override
                    public Message call() throws Exception {
                        return origin.unwrap();
                    }
                });
            }
            catch (ExecutionException ex) {
                throw new IOException(ex);
            }
        }

        public String toString() {
            return "Envelope.Constant(origin=" + this.origin + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Constant)) {
                return false;
            }
            Constant other = (Constant)o;
            Envelope this$origin = this.origin;
            Envelope other$origin = other.origin;
            return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Envelope $origin = this.origin;
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            return result;
        }
    }

    @Immutable
    @Loggable(value=1)
    public static final class Safe
    implements Envelope {
        private final transient Envelope origin;

        public Safe(Envelope env) {
            this.origin = env;
        }

        @Override
        public Message unwrap() throws IOException {
            Message msg = this.origin.unwrap();
            try {
                if (msg.getAllRecipients() == null) {
                    msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress("to@example.com"));
                    Logger.warn((Object)this, (String)"recipients were NULL, fake one set");
                }
                if (msg.getFrom() == null) {
                    msg.setFrom((Address)new InternetAddress("from@example.com"));
                    Logger.warn((Object)this, (String)"senders were NULL, fake one set");
                }
                if (msg.getSubject() == null) {
                    msg.setSubject(this.getClass().getCanonicalName());
                    Logger.warn((Object)this, (String)"subject was NULL, fake one set");
                }
            }
            catch (MessagingException ex) {
                throw new IOException(ex);
            }
            return msg;
        }

        public String toString() {
            return "Envelope.Safe(origin=" + this.origin + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Safe)) {
                return false;
            }
            Safe other = (Safe)o;
            Envelope this$origin = this.origin;
            Envelope other$origin = other.origin;
            return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Envelope $origin = this.origin;
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            return result;
        }
    }

    @Immutable
    @Loggable(value=1)
    public static final class Strict
    implements Envelope {
        private final transient Envelope origin;

        public Strict(Envelope env) {
            this.origin = env;
        }

        @Override
        public Message unwrap() throws IOException {
            Message msg = this.origin.unwrap();
            try {
                if (msg.getAllRecipients() == null) {
                    throw new IllegalStateException("list of recipients is NULL");
                }
                if (msg.getFrom() == null) {
                    throw new IllegalStateException("list of senders is NULL");
                }
                if (msg.getSubject() == null) {
                    throw new IllegalStateException("subject is NULL");
                }
            }
            catch (MessagingException ex) {
                throw new IOException(ex);
            }
            return msg;
        }

        public String toString() {
            return "Envelope.Strict(origin=" + this.origin + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Strict)) {
                return false;
            }
            Strict other = (Strict)o;
            Envelope this$origin = this.origin;
            Envelope other$origin = other.origin;
            return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Envelope $origin = this.origin;
            result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
            return result;
        }
    }

    @Immutable
    @Loggable(value=1)
    public static final class Mime
    implements Envelope {
        private final transient Array<Stamp> stamps;
        private final transient Array<Enclosure> encs;

        public Mime() {
            this((Iterable<Stamp>)new Array(), (Iterable<Enclosure>)new Array());
        }

        public Mime(Envelope env) {
            this((Iterable<Stamp>)((Mime)Mime.class.cast((Object)env)).stamps, (Iterable<Enclosure>)((Mime)Mime.class.cast((Object)env)).encs);
        }

        public Mime(Iterable<Stamp> stmps, Iterable<Enclosure> list) {
            this.stamps = new Array(stmps);
            this.encs = new Array(list);
        }

        @Override
        public Message unwrap() throws IOException {
            Message msg = EMPTY.unwrap();
            MimeMultipart multi = new MimeMultipart("alternative");
            try {
                for (Enclosure enc : this.encs) {
                    multi.addBodyPart((BodyPart)enc.part());
                }
                for (Stamp stamp : this.stamps) {
                    stamp.attach(msg);
                }
                msg.setContent((Multipart)multi);
            }
            catch (MessagingException ex) {
                throw new IOException(ex);
            }
            return msg;
        }

        public Mime with(Stamp stamp) {
            return new Mime((Iterable<Stamp>)this.stamps.with((Object)stamp), (Iterable<Enclosure>)this.encs);
        }

        public Mime with(Enclosure enc) {
            return new Mime((Iterable<Stamp>)this.stamps, (Iterable<Enclosure>)this.encs.with((Object)enc));
        }

        public String toString() {
            return "Envelope.Mime(stamps=" + this.stamps + ", encs=" + this.encs + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mime)) {
                return false;
            }
            Mime other = (Mime)o;
            Array<Enclosure> this$encs = this.encs;
            Array<Enclosure> other$encs = other.encs;
            return !(this$encs == null ? other$encs != null : !this$encs.equals(other$encs));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Array<Enclosure> $encs = this.encs;
            result = result * 59 + ($encs == null ? 43 : $encs.hashCode());
            return result;
        }
    }
}

