/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.email;

import com.google.common.collect.ImmutableMap;
import com.jcabi.aspects.Immutable;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

@Immutable
public interface Protocol {
    public Map<String, String> entries();

    public static final class Smtps
    implements Protocol {
        private final transient String host;
        private final transient int port;

        public Smtps(String hst, int prt) {
            this.host = hst;
            this.port = prt;
        }

        @Override
        public Map<String, String> entries() {
            return new ImmutableMap.Builder().put((Object)"mail.smtps.auth", (Object)Boolean.TRUE.toString()).put((Object)"mail.smtps.host", (Object)this.host).put((Object)"mail.smtps.port", (Object)Integer.toString(this.port)).put((Object)"mail.smtp.ssl.checkserveridentity", (Object)Boolean.TRUE.toString()).put((Object)"mail.smtp.socketFactory.class", (Object)SSLSocketFactory.class.getName()).put((Object)"mail.smtp.socketFactory.port", (Object)Integer.toString(this.port)).put((Object)"mail.smtp.socketFactory.fallback", (Object)"false").build();
        }
    }

    public static final class Smtp
    implements Protocol {
        private final transient String host;
        private final transient int port;

        public Smtp(String hst, int prt) {
            this.host = hst;
            this.port = prt;
        }

        @Override
        public Map<String, String> entries() {
            return new ImmutableMap.Builder().put((Object)"mail.smtp.auth", (Object)Boolean.TRUE.toString()).put((Object)"mail.smtp.host", (Object)this.host).put((Object)"mail.smtp.port", (Object)Integer.toString(this.port)).build();
        }
    }
}

