/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.email;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.email.Protocol;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;

@Immutable
@Loggable(value=1)
public final class Token {
    private final transient String user;
    private final transient String password;

    public Token(String usr, String pwd) {
        this.user = usr;
        this.password = pwd;
    }

    public Session access(Protocol protocol) {
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : protocol.entries().entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        return Session.getInstance((Properties)props, (Authenticator)new Verification(this.user, this.password));
    }

    public String toString() {
        return "Token(user=" + this.user + ", password=" + this.password + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Token)) {
            return false;
        }
        Token other = (Token)o;
        String this$user = this.user;
        String other$user = other.user;
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.password;
        String other$password = other.password;
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $user = this.user;
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.password;
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }

    private static final class Verification
    extends Authenticator {
        private final transient String user;
        private final transient String password;

        Verification(String usr, String pwd) {
            this.user = usr;
            this.password = pwd;
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password);
        }
    }
}

