/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.email.enclosure;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.email.Enclosure;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;

@Immutable
@Loggable(value=1)
public final class EnPlain
implements Enclosure {
    private final transient String text;
    private final transient String charset;

    public EnPlain(String content) {
        this(content, "UTF-8");
    }

    public EnPlain(String content, String charset) {
        this.text = content;
        this.charset = charset;
    }

    @Override
    public MimeBodyPart part() throws MessagingException {
        if (this.text == null) {
            throw new IllegalArgumentException("Attachment text can't be NULL");
        }
        if (this.charset == null) {
            throw new IllegalArgumentException("Attachment charset can't be NULL");
        }
        MimeBodyPart mime = new MimeBodyPart();
        mime.setText(this.text, this.charset);
        mime.addHeader("Content-Type", "text/plain");
        return mime;
    }

    public String toString() {
        return "EnPlain(text=" + this.text + ", charset=" + this.charset + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnPlain)) {
            return false;
        }
        EnPlain other = (EnPlain)o;
        String this$text = this.text;
        String other$text = other.text;
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$charset = this.charset;
        String other$charset = other.charset;
        return !(this$charset == null ? other$charset != null : !this$charset.equals(other$charset));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.text;
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $charset = this.charset;
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        return result;
    }
}

