/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.email.postman;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.email.Envelope;
import com.jcabi.email.Postman;
import com.jcabi.log.Logger;
import java.io.IOException;
import javax.mail.Flags;
import javax.mail.Message;
import javax.mail.MessagingException;

@Immutable
@Loggable(value=1)
public final class PostNoDrafts
implements Postman {
    private final transient Postman origin;

    public PostNoDrafts(Postman post) {
        this.origin = post;
    }

    @Override
    public void send(Envelope env) throws IOException {
        Message message = env.unwrap();
        try {
            if (message.isSet(Flags.Flag.DRAFT)) {
                Logger.info((Object)this, (String)"message has DRAFT flag, ignoring");
            } else {
                this.origin.send(env);
            }
        }
        catch (MessagingException ex) {
            throw new IOException(ex);
        }
    }

    public String toString() {
        return "PostNoDrafts(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostNoDrafts)) {
            return false;
        }
        PostNoDrafts other = (PostNoDrafts)o;
        Postman this$origin = this.origin;
        Postman other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Postman $origin = this.origin;
        result = result * 59 + ($origin == null ? 43 : $origin.hashCode());
        return result;
    }
}

