/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.email.stamp;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.email.Stamp;
import java.io.UnsupportedEncodingException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;

@Immutable
@Loggable(value=1)
public final class StCc
implements Stamp {
    private final transient String email;

    public StCc(Address addr) {
        this(addr.toString());
    }

    public StCc(String name, String addr) {
        this(name, addr, "UTF-8");
    }

    public StCc(String name, String addr, String charset) {
        this(StCc.addr(name, addr, charset));
    }

    public StCc(String addr) {
        this.email = addr;
    }

    @Override
    public void attach(Message message) throws MessagingException {
        if (this.email == null) {
            throw new IllegalArgumentException("Email address can't be NULL");
        }
        message.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(this.email));
    }

    private static String addr(String name, String addr, String charset) {
        try {
            return new InternetAddress(addr, name, charset).toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String toString() {
        return "StCc(email=" + this.email + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StCc)) {
            return false;
        }
        StCc other = (StCc)o;
        String this$email = this.email;
        String other$email = other.email;
        return !(this$email == null ? other$email != null : !this$email.equals(other$email));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $email = this.email;
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        return result;
    }
}

