/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.email.stamp;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.email.Stamp;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;

@Immutable
@Loggable(value=1)
public final class StReplyTo
implements Stamp {
    private final transient String email;

    public StReplyTo(Address addr) {
        this(addr.toString());
    }

    public StReplyTo(String addr) {
        this.email = addr;
    }

    @Override
    public void attach(Message message) throws MessagingException {
        if (this.email == null) {
            throw new IllegalArgumentException("Email address can't be NULL");
        }
        Address[] addresses = new Address[]{new InternetAddress(this.email)};
        message.setReplyTo(addresses);
    }

    public String toString() {
        return "StReplyTo(email=" + this.email + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StReplyTo)) {
            return false;
        }
        StReplyTo other = (StReplyTo)o;
        String this$email = this.email;
        String other$email = other.email;
        return !(this$email == null ? other$email != null : !this$email.equals(other$email));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $email = this.email;
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        return result;
    }
}

