/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.email.stamp;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.email.Stamp;
import java.io.UnsupportedEncodingException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeUtility;

@Immutable
@Loggable(value=1)
public final class StSubject
implements Stamp {
    private final transient String subject;
    private final transient String charset;

    public StSubject(String subj) {
        this(subj, "UTF-8");
    }

    public StSubject(String subj, String charset) {
        this.subject = subj;
        this.charset = charset;
    }

    @Override
    public void attach(Message message) throws MessagingException {
        if (this.subject == null) {
            throw new IllegalArgumentException("Email subject can't be NULL");
        }
        if (this.charset == null) {
            throw new IllegalArgumentException("Subject charset can't be NULL");
        }
        try {
            message.setSubject(MimeUtility.encodeText((String)this.subject, (String)this.charset, (String)"Q"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public String toString() {
        return "StSubject(subject=" + this.subject + ", charset=" + this.charset + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StSubject)) {
            return false;
        }
        StSubject other = (StSubject)o;
        String this$subject = this.subject;
        String other$subject = other.subject;
        if (this$subject == null ? other$subject != null : !this$subject.equals(other$subject)) {
            return false;
        }
        String this$charset = this.charset;
        String other$charset = other.charset;
        return !(this$charset == null ? other$charset != null : !this$charset.equals(other$charset));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $subject = this.subject;
        result = result * 59 + ($subject == null ? 43 : $subject.hashCode());
        String $charset = this.charset;
        result = result * 59 + ($charset == null ? 43 : $charset.hashCode());
        return result;
    }
}

