/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.email;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.email.Envelope;
import com.jcabi.email.Wire;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.util.Arrays;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Transport;

@Immutable
public interface Postman {
    public static final Postman CONSOLE = new Postman(){

        @Override
        public void send(Envelope env) throws IOException {
            Message msg = new Envelope.Strict(env).unwrap();
            try {
                Logger.info((Object)this, (String)"fake email \"%s\" from %s to %s", (Object[])new Object[]{msg.getSubject(), Arrays.asList(msg.getFrom()), Arrays.asList(msg.getAllRecipients())});
            }
            catch (MessagingException ex) {
                throw new IOException(ex);
            }
        }
    };

    public void send(Envelope var1) throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Default
    implements Postman {
        private final transient Wire wire;

        public Default(Wire wre) {
            this.wire = wre;
        }

        @Override
        public void send(Envelope env) throws IOException {
            Message message = new Envelope.Strict(env).unwrap();
            Transport transport = this.wire.connect();
            try {
                Address[] rcpts = message.getAllRecipients();
                transport.sendMessage(message, rcpts);
                Logger.info((Object)this, (String)"email sent from %s to %[list]s", (Object[])new Object[]{Arrays.asList(message.getFrom()), Arrays.asList(rcpts)});
            }
            catch (MessagingException ex) {
                throw new IOException(ex);
            }
            finally {
                Default.close(transport);
            }
        }

        private static void close(Transport transport) throws IOException {
            try {
                transport.close();
            }
            catch (MessagingException ex) {
                throw new IOException(ex);
            }
        }

        public String toString() {
            return "Postman.Default(wire=" + this.wire + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Default)) {
                return false;
            }
            Default other = (Default)o;
            Wire this$wire = this.wire;
            Wire other$wire = other.wire;
            return !(this$wire == null ? other$wire != null : !this$wire.equals(other$wire));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Wire $wire = this.wire;
            result = result * 59 + ($wire == null ? 0 : $wire.hashCode());
            return result;
        }
    }
}

