/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.email.enclosure;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.email.Enclosure;
import java.io.File;
import java.io.IOException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;

@Immutable
@Loggable(value=1)
public final class EnBinary
implements Enclosure {
    private final transient String path;
    private final transient String name;
    private final transient String ctype;

    public EnBinary(File file, String label, String type) {
        this.path = file.getAbsolutePath();
        this.name = label;
        this.ctype = type;
    }

    @Override
    public MimeBodyPart part() throws MessagingException {
        MimeBodyPart mime = new MimeBodyPart();
        try {
            mime.attachFile(new File(this.path));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        mime.setFileName(this.name);
        mime.addHeader("Content-Type", this.ctype);
        return mime;
    }

    public String toString() {
        return "EnBinary(path=" + this.path + ", name=" + this.name + ", ctype=" + this.ctype + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnBinary)) {
            return false;
        }
        EnBinary other = (EnBinary)o;
        String this$path = this.path;
        String other$path = other.path;
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$name = this.name;
        String other$name = other.name;
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$ctype = this.ctype;
        String other$ctype = other.ctype;
        return !(this$ctype == null ? other$ctype != null : !this$ctype.equals(other$ctype));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.path;
        result = result * 59 + ($path == null ? 0 : $path.hashCode());
        String $name = this.name;
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        String $ctype = this.ctype;
        result = result * 59 + ($ctype == null ? 0 : $ctype.hashCode());
        return result;
    }
}

