/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.email.postman;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.email.Envelope;
import com.jcabi.email.Postman;
import com.jcabi.log.Logger;
import java.io.IOException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;

@Immutable
@Loggable(value=1)
public final class PostNoLoops
implements Postman {
    private final transient Postman origin;

    public PostNoLoops(Postman post) {
        this.origin = post;
    }

    @Override
    public void send(Envelope env) throws IOException {
        Message msg = env.unwrap();
        try {
            boolean intersects;
            Address[] rcpts = msg.getAllRecipients();
            Address[] reply = msg.getReplyTo();
            Address[] from = msg.getFrom();
            boolean bl = intersects = this.intersect(rcpts, reply, "Reply-To and Recipients") || this.intersect(rcpts, from, "Recipients and From");
            if (!intersects) {
                this.origin.send(env);
            }
        }
        catch (MessagingException ex) {
            throw new IOException(ex);
        }
    }

    private boolean intersect(Address[] first, Address[] second, String msg) {
        boolean intersect = false;
        if (first != null && second != null) {
            for (Address left : first) {
                for (Address right : second) {
                    String rht;
                    String lft = ((InternetAddress)InternetAddress.class.cast(left)).getAddress();
                    if (!lft.equals(rht = ((InternetAddress)InternetAddress.class.cast(right)).getAddress())) continue;
                    Logger.info((Object)this, (String)"%s exists in %s as %s and %s", (Object[])new Object[]{lft, msg, left, right});
                    intersect = true;
                }
            }
        }
        return intersect;
    }

    public String toString() {
        return "PostNoLoops(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostNoLoops)) {
            return false;
        }
        PostNoLoops other = (PostNoLoops)o;
        Postman this$origin = this.origin;
        Postman other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Postman $origin = this.origin;
        result = result * 59 + ($origin == null ? 0 : $origin.hashCode());
        return result;
    }
}

