/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.email.stamp;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.email.Stamp;
import java.io.UnsupportedEncodingException;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;

@Immutable
@Loggable(value=1)
public final class StSender
implements Stamp {
    private final transient String email;

    public StSender(Address addr) {
        this(addr.toString());
    }

    public StSender(String name, String addr) {
        try {
            this.email = new InternetAddress(addr, name, "UTF-8").toString();
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public StSender(String addr) {
        this.email = addr;
    }

    @Override
    public void attach(Message message) throws MessagingException {
        message.setFrom((Address)new InternetAddress(this.email));
    }

    public String toString() {
        return "StSender(email=" + this.email + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StSender)) {
            return false;
        }
        StSender other = (StSender)o;
        String this$email = this.email;
        String other$email = other.email;
        return !(this$email == null ? other$email != null : !this$email.equals(other$email));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $email = this.email;
        result = result * 59 + ($email == null ? 0 : $email.hashCode());
        return result;
    }
}

