/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.email.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.email.Wire;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.util.Properties;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;

@Immutable
@Loggable(value=1)
public final class SMTP
implements Wire {
    private final transient String host;
    private final transient int port;
    private final transient String user;
    private final transient String password;

    public SMTP(String hst, int prt, String usr, String pwd) {
        this.host = hst;
        this.port = prt;
        this.user = usr;
        this.password = pwd;
    }

    @Override
    public Transport connect() throws IOException {
        Properties props = new Properties();
        props.setProperty("mail.smtp.auth", "true");
        Session session = Session.getInstance((Properties)props);
        try {
            Transport transport = session.getTransport("smtp");
            transport.connect(this.host, this.port, this.user, this.password);
            Logger.info((Object)this, (String)"sending email through %s:%s as %s...", (Object[])new Object[]{this.host, this.port, this.user});
            return transport;
        }
        catch (MessagingException ex) {
            throw new IOException(ex);
        }
    }

    public String toString() {
        return "SMTP(host=" + this.host + ", port=" + this.port + ", user=" + this.user + ", password=" + this.password + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SMTP)) {
            return false;
        }
        SMTP other = (SMTP)o;
        String this$host = this.host;
        String other$host = other.host;
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        String this$user = this.user;
        String other$user = other.user;
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.password;
        String other$password = other.password;
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $host = this.host;
        result = result * 59 + ($host == null ? 0 : $host.hashCode());
        result = result * 59 + this.port;
        String $user = this.user;
        result = result * 59 + ($user == null ? 0 : $user.hashCode());
        String $password = this.password;
        result = result * 59 + ($password == null ? 0 : $password.hashCode());
        return result;
    }
}

