/**
 * Copyright (c) 2013-2022, jcabi.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met: 1) Redistributions of source code must retain the above
 * copyright notice, this list of conditions and the following
 * disclaimer. 2) Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided
 * with the distribution. 3) Neither the name of the jcabi.com nor
 * the names of its contributors may be used to endorse or promote
 * products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;

/**
 * Github users.
 *
 * @author Yegor Bugayenko (yegor256@gmail.com)
 * @version $Id: 6ca2252624fd3560b059417b746f81563ee819ec $
 * @since 0.1
 * @see <a href="https://developer.github.com/v3/users/">Users API</a>
 */
@Immutable
public interface Users {

    /**
     * Github we're in.
     * @return Github
     */
    Github github();

    /**
     * Get myself.
     * @return Myself
     */
    User self();

    /**
     * Get user by login.
     * @param login Login of it
     * @return User
     * @see <a href="http://developer.github.com/v3/users/#get-a-single-user">Get a Single User</a>
     */
    User get(String login);

    /**
     * Add user by login and returns it.
     * @param login Login of it
     * @return Added user
     */
    User add(String login);

    /**
     * Iterate all users, starting with the one you've seen already.
     * @param identifier The integer ID of the last User that you’ve seen.
     * @return Iterator of gists
     * @see <a href="http://developer.github.com/v3/users/#get-all-users">Get All Users</a>
     */
    Iterable<User> iterate(
        String identifier
    );

}
