/**
 * Copyright (c) 2013-2024, jcabi.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met: 1) Redistributions of source code must retain the above
 * copyright notice, this list of conditions and the following
 * disclaimer. 2) Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided
 * with the distribution. 3) Neither the name of the jcabi.com nor
 * the names of its contributors may be used to endorse or promote
 * products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import java.io.IOException;
import lombok.EqualsAndHashCode;

/**
 * Check if a Github JSON object actually exists on the server.
 *
 * @author Mihai Andronache (amihaiemil@gmail.com)
 * @version $Id: a709136c8e2972d237139533677be14aa5955722 $
 * @since 0.38
 */
@Immutable
@Loggable(Loggable.DEBUG)
@EqualsAndHashCode(of = "readable")
final class Existence {

    /**
     * Checked object.
     */
    private final transient JsonReadable readable;

    /**
     * Ctor.
     * @param rdbl Checked object.
     */
    Existence(final JsonReadable rdbl) {
        this.readable = rdbl;
    }

    /**
     * Check existence.
     * @return True if exists, false otherwise.
     * @throws IOException If there is a networking problem.
     */
    public boolean check() throws IOException {
        boolean exists = true;
        try {
            this.readable.json();
        } catch (final AssertionError ex) {
            exists = false;
        } catch (final IndexOutOfBoundsException ex) {
            exists = false;
        }
        return exists;
    }

}
