/**
 * Copyright (c) 2013-2024, jcabi.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met: 1) Redistributions of source code must retain the above
 * copyright notice, this list of conditions and the following
 * disclaimer. 2) Redistributions in binary form must reproduce the above
 * copyright notice, this list of conditions and the following
 * disclaimer in the documentation and/or other materials provided
 * with the distribution. 3) Neither the name of the jcabi.com nor
 * the names of its contributors may be used to endorse or promote
 * products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import java.io.IOException;
import javax.json.JsonObject;

/**
 * Github Git Data Trees.
 *
 * @author Carlos Miranda (miranda.cma@gmail.com)
 * @version $Id: 22a571669f4886d3588a538eeaa6d01bfb206176 $
 * @since 0.8
 * @see <a href="https://developer.github.com/v3/git/trees/">Trees API</a>
 */
@Immutable
public interface Trees {

    /**
     * Owner of them.
     * @return Repo
     */
    Repo repo();

    /**
     * Get specific tree by sha.
     * @param sha Tree sha
     * @return Tree
     * @see <a href="https://developer.github.com/v3/git/trees">Get a tree</a>
     */
    Tree get(String sha);

    /**
     * Get specific tree recursively by sha.
     * @param sha Tree sha
     * @return Tree
     * @see <a href="https://developer.github.com/v3/git/trees">Get a tree</a>
     */
    Tree getRec(String sha);
    /**
     * Create new tree.
     * @param params Parameters to create new tree
     * @return Tree
     * @throws java.io.IOException If there is any I/O problem
     */
    Tree create(
        JsonObject params)
        throws IOException;
}
