/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.http.wire;

import com.jcabi.aspects.Immutable;
import com.jcabi.http.ImmutableHeader;
import com.jcabi.http.Request;
import com.jcabi.http.Response;
import com.jcabi.http.Wire;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.validation.constraints.NotNull;
import javax.xml.bind.DatatypeConverter;

@Immutable
public final class BasicAuthWire
implements Wire {
    private static final String ENCODING = "UTF-8";
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private final transient Wire origin;

    public BasicAuthWire(@NotNull(message="wire can't be NULL") Wire wire) {
        this.origin = wire;
    }

    @Override
    public Response send(Request req, String home, String method, Collection<Map.Entry<String, String>> headers, InputStream content) throws IOException {
        LinkedList<Map.Entry<String, String>> hdrs = new LinkedList<Map.Entry<String, String>>();
        boolean absent = true;
        for (Map.Entry<String, String> header : headers) {
            if (header.getKey().equals("Authorization")) {
                absent = false;
            }
            hdrs.add(header);
        }
        String info = URI.create(home).getUserInfo();
        if (absent && info != null) {
            String[] parts = info.split(":", 2);
            try {
                hdrs.add(new ImmutableHeader("Authorization", Logger.format((String)"Basic %s", (Object[])new Object[]{DatatypeConverter.printBase64Binary((byte[])Logger.format((String)"%s:%s", (Object[])new Object[]{URLEncoder.encode(parts[0], ENCODING), URLEncoder.encode(parts[1], ENCODING)}).getBytes(CHARSET))})));
            }
            catch (UnsupportedEncodingException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return this.origin.send(req, home, method, hdrs, content);
    }

    public String toString() {
        return "BasicAuthWire(origin=" + this.origin + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicAuthWire)) {
            return false;
        }
        BasicAuthWire other = (BasicAuthWire)o;
        Wire this$origin = this.origin;
        Wire other$origin = other.origin;
        return !(this$origin == null ? other$origin != null : !this$origin.equals(other$origin));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wire $origin = this.origin;
        result = result * 59 + ($origin == null ? 0 : $origin.hashCode());
        return result;
    }
}

